/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

public class GlobalOperationHandlers {
    public static final OperationHandler READ_RESOURCE = new ReadResourceHandler();
    public static final OperationHandler READ_ATTRIBUTE = new ReadAttributeHandler();
    public static final OperationHandler READ_CHILDREN_NAMES = new ReadChildrenNamesOperationHandler();
    public static final OperationHandler READ_CHILDREN_RESOURCES = new ReadChildrenResourcesOperationHandler();
    public static final OperationHandler WRITE_ATTRIBUTE = new WriteAttributeHandler();
    public static final ResolveAddressOperationHandler RESOLVE = new ResolveAddressOperationHandler();
    public static final ModelQueryOperationHandler READ_CHILDREN_TYPES = new ModelQueryOperationHandler(){

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            ModelNode subModel = context.getSubModel().clone();
            if (!subModel.isDefined()) {
                ModelNode result = new ModelNode();
                result.setEmptyList();
                resultHandler.handleResultFragment(new String[0], result);
            } else {
                Set<String> childTypes = context.getRegistry().getChildNames(PathAddress.pathAddress(operation.get("address")));
                ModelNode result = new ModelNode();
                for (String key : childTypes) {
                    ModelNode node = new ModelNode();
                    node.set(key);
                    result.add(node);
                }
                resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            }
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
    };
    public static final ModelQueryOperationHandler READ_OPERATION_NAMES = new ModelQueryOperationHandler(){

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            ModelNodeRegistration registry = context.getRegistry();
            Map<String, OperationEntry> operations = registry.getOperationDescriptions(PathAddress.pathAddress(operation.get("address")), true);
            ModelNode result = new ModelNode();
            if (operations.size() > 0) {
                for (Map.Entry<String, OperationEntry> entry : operations.entrySet()) {
                    if (entry.getValue().getType() != OperationEntry.EntryType.PUBLIC) continue;
                    result.add(entry.getKey());
                }
            } else {
                result.setEmptyList();
            }
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
    };
    public static final ModelQueryOperationHandler READ_OPERATION_DESCRIPTION = new ModelQueryOperationHandler(){

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            String operationName = operation.require("name").asString();
            ModelNodeRegistration registry = context.getRegistry();
            DescriptionProvider descriptionProvider = registry.getOperationDescription(PathAddress.pathAddress(operation.get("address")), operationName);
            ModelNode result = descriptionProvider == null ? new ModelNode() : descriptionProvider.getModelDescription(GlobalOperationHandlers.getLocale(operation));
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
    };
    public static final ModelQueryOperationHandler READ_RESOURCE_DESCRIPTION = new ModelQueryOperationHandler(){

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            boolean operations = operation.get("operations").isDefined() ? operation.get("operations").asBoolean() : false;
            boolean recursive = operation.get("recursive").isDefined() ? operation.get("recursive").asBoolean() : false;
            ModelNodeRegistration registry = context.getRegistry();
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            DescriptionProvider descriptionProvider = registry.getModelDescription(address);
            Locale locale = GlobalOperationHandlers.getLocale(operation);
            ModelNode result = descriptionProvider.getModelDescription(locale);
            this.addDescription(context, result, recursive, operations, registry, address, locale);
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        private void addDescription(OperationContext context, ModelNode result, boolean recursive, boolean operations, ModelNodeRegistration registry, PathAddress address, Locale locale) throws OperationFailedException {
            DescriptionProvider provider;
            if (operations) {
                Map<String, OperationEntry> ops = registry.getOperationDescriptions(address, true);
                if (ops.size() > 0) {
                    for (Map.Entry<String, OperationEntry> entry : ops.entrySet()) {
                        if (entry.getValue().getType() != OperationEntry.EntryType.PUBLIC) continue;
                        provider = entry.getValue().getDescriptionProvider();
                        result.get(new String[]{"operations", entry.getKey()}).set(provider.getModelDescription(locale));
                    }
                } else {
                    result.get("operations").setEmptyList();
                }
            }
            if (result.hasDefined("attributes")) {
                for (String attr : result.require("attributes").keys()) {
                    AttributeAccess access = registry.getAttributeAccess(address, attr);
                    AttributeAccess.AccessType accessType = access == null ? AttributeAccess.AccessType.READ_ONLY : access.getAccessType();
                    AttributeAccess.Storage storage = access == null ? AttributeAccess.Storage.CONFIGURATION : access.getStorageType();
                    result.get(new String[]{"attributes", attr, "access-type"}).set(accessType.toString());
                    result.get(new String[]{"attributes", attr, "storage"}).set(storage.toString());
                }
            }
            if (recursive && result.hasDefined("children")) {
                for (PathElement element : registry.getChildAddresses(address)) {
                    ModelNode child;
                    PathAddress childAddress = address.append(element);
                    provider = registry.getModelDescription(childAddress);
                    if (provider == null) {
                        Set<ProxyController> proxyControllers = registry.getProxyControllers(childAddress);
                        if (proxyControllers.size() != 1) {
                            throw new IllegalStateException("No description provider found for " + childAddress + ". Tried to search for proxies, expected to find 1 proxy controller, found: " + proxyControllers.size());
                        }
                        ModelNode operation = new ModelNode();
                        operation.get("operation").set("read-resource-description");
                        operation.get("address").set(new ModelNode());
                        operation.get("recursive").set(true);
                        operation.get("operations").set(operations);
                        if (locale != null) {
                            operation.get("operations").set(locale.toString());
                        }
                        child = proxyControllers.iterator().next().execute(OperationBuilder.Factory.copy((OperationAttachments)context, (ModelNode)operation).build()).get("result");
                    } else {
                        child = provider.getModelDescription(locale);
                        this.addDescription(context, child, recursive, operations, registry, childAddress, locale);
                    }
                    result.get(new String[]{"children", element.getKey(), "model-description", element.getValue()}).set(child);
                }
            }
        }
    };

    private GlobalOperationHandlers() {
    }

    private static Locale getLocale(ModelNode operation) {
        if (!operation.hasDefined("locale")) {
            return null;
        }
        return new Locale(operation.get("locale").asString());
    }

    public static final class ResolveAddressOperationHandler
    implements ModelQueryOperationHandler,
    DescriptionProvider {
        public static final String OPERATION_NAME = "resolve-address";
        public static final String ADDRESS_PARAM = "address-to-resolve";
        public static final String ORIGINAL_OPERATION = "original-operation";

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
            OperationHandler operationHandler;
            PathAddress address = PathAddress.pathAddress(operation.require(ADDRESS_PARAM));
            String operationName = operation.require(ORIGINAL_OPERATION).asString();
            Set<ProxyController> proxies = context.getRegistry().getProxyControllers(address);
            int size = proxies.size();
            if (size > 0) {
                final AtomicInteger count = new AtomicInteger(size);
                final AtomicInteger status = new AtomicInteger();
                final ModelNode failureResult = new ModelNode();
                Iterator i$ = proxies.iterator();
                if (i$.hasNext()) {
                    ProxyController proxy = (ProxyController)i$.next();
                    final PathAddress proxyAddress = proxy.getProxyNodeAddress();
                    ModelNode newOperation = operation.clone();
                    newOperation.get("address").set(address.subAddress(proxyAddress.size()).toModelNode());
                    Operation operationContext = OperationBuilder.Factory.create((ModelNode)newOperation).build();
                    proxy.execute(operationContext, new ResultHandler(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleResultFragment(String[] location, ModelNode result) {
                            ModelNode modelNode = failureResult;
                            synchronized (modelNode) {
                                if (status.get() == 0) {
                                    PathAddress resolved = PathAddress.pathAddress(result);
                                    resultHandler.handleResultFragment(Util.NO_LOCATION, proxyAddress.append(resolved).toModelNode());
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleResultComplete() {
                            ModelNode modelNode = failureResult;
                            synchronized (modelNode) {
                                status.compareAndSet(0, 1);
                                if (count.decrementAndGet() == 0) {
                                    this.handleComplete();
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleFailed(ModelNode failureDescription) {
                            ModelNode modelNode = failureResult;
                            synchronized (modelNode) {
                                if (failureDescription != null) {
                                    failureResult.add(failureDescription);
                                }
                                status.compareAndSet(0, 2);
                                if (count.decrementAndGet() == 0) {
                                    this.handleComplete();
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void handleCancellation() {
                            ModelNode modelNode = failureResult;
                            synchronized (modelNode) {
                                status.compareAndSet(0, 3);
                                if (count.decrementAndGet() == 0) {
                                    this.handleComplete();
                                }
                            }
                        }

                        private void handleComplete() {
                            int s = status.get();
                            switch (s) {
                                case 1: {
                                    resultHandler.handleResultComplete();
                                    break;
                                }
                                case 2: {
                                    resultHandler.handleFailed(new ModelNode());
                                    break;
                                }
                                case 3: {
                                    resultHandler.handleCancellation();
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                    });
                    return new BasicOperationResult();
                }
            }
            if ((operationHandler = context.getRegistry().getOperationHandler(address, operationName)) == null) {
                resultHandler.handleFailed(new ModelNode().set("no operation handler" + operationName));
                return new BasicOperationResult();
            }
            Set<PathAddress> resolved = operationHandler instanceof ModelQueryOperationHandler ? PathAddress.resolve(address, context.getSubModel(), operationHandler instanceof ModelAddOperationHandler) : context.getRegistry().resolveAddress(address);
            if (!resolved.isEmpty()) {
                for (PathAddress a : resolved) {
                    resultHandler.handleResultFragment(Util.NO_LOCATION, a.toModelNode());
                }
            }
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    }

    public static class ReadChildrenResourcesOperationHandler
    extends ReadResourceHandler {
        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
            String childName = operation.require("child-type").asString();
            ModelNode subModel = context.getSubModel().clone();
            if (!subModel.isDefined()) {
                ModelNode result = new ModelNode();
                result.setEmptyList();
                resultHandler.handleResultFragment(new String[0], result);
                resultHandler.handleResultComplete();
            } else {
                PathAddress address = PathAddress.pathAddress(operation.get("address"));
                Set<String> childNames = context.getRegistry().getChildNames(address);
                if (!childNames.contains(childName)) {
                    throw new OperationFailedException(new ModelNode().set("No known child called " + childName));
                }
                final AtomicBoolean ok = new AtomicBoolean(true);
                ModelNode result = new ModelNode();
                if (!(subModel = subModel.get(childName)).isDefined()) {
                    result.setEmptyList();
                } else {
                    for (String key : subModel.keys()) {
                        if (!ok.get()) break;
                        PathAddress childAddress = address.append(PathElement.pathElement(childName, key));
                        ModelNode readOp = operation.clone();
                        readOp.get("address").set(childAddress.toModelNode());
                        if (operation.hasDefined("include-runtime")) {
                            readOp.get("include-runtime").set(operation.get("include-runtime").asBoolean());
                        }
                        ModelNode readResult = this.readModel(context, readOp, new ResultHandler(){

                            @Override
                            public void handleResultFragment(String[] location, ModelNode result) {
                            }

                            @Override
                            public void handleResultComplete() {
                            }

                            @Override
                            public void handleFailed(ModelNode failureDescription) {
                                ok.set(false);
                                resultHandler.handleFailed(failureDescription);
                            }

                            @Override
                            public void handleCancellation() {
                                ok.set(false);
                                resultHandler.handleCancellation();
                            }
                        }, childAddress);
                        result.add(key, readResult);
                    }
                }
                if (ok.get()) {
                    resultHandler.handleResultFragment(Util.NO_LOCATION, result);
                    resultHandler.handleResultComplete();
                }
            }
            return new BasicOperationResult();
        }
    }

    public static class ReadChildrenNamesOperationHandler
    implements ModelQueryOperationHandler {
        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            String childName = operation.require("child-type").asString();
            ModelNode subModel = context.getSubModel().clone();
            if (!subModel.isDefined()) {
                ModelNode result = new ModelNode();
                result.setEmptyList();
                resultHandler.handleResultFragment(new String[0], result);
            } else {
                PathAddress address = PathAddress.pathAddress(operation.get("address"));
                Set<String> childNames = context.getRegistry().getChildNames(address);
                if (!childNames.contains(childName)) {
                    throw new OperationFailedException(new ModelNode().set("No known child called " + childName));
                }
                ModelNode result = new ModelNode();
                if (!(subModel = subModel.get(childName)).isDefined()) {
                    result.setEmptyList();
                } else {
                    for (String key : subModel.keys()) {
                        ModelNode node = new ModelNode();
                        node.set(key);
                        result.add(node);
                    }
                }
                resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            }
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
    }

    public static class WriteAttributeHandler
    implements ModelUpdateOperationHandler {
        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            OperationResult handlerResult = null;
            String attributeName = operation.require("name").asString();
            AttributeAccess attributeAccess = context.getRegistry().getAttributeAccess(PathAddress.pathAddress(operation.get("address")), attributeName);
            if (attributeAccess == null) {
                throw new OperationFailedException(new ModelNode().set("No known attribute called " + attributeName));
            }
            if (attributeAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) {
                throw new OperationFailedException(new ModelNode().set("Attribute " + attributeName + " is not writeable"));
            }
            handlerResult = attributeAccess.getWriteHandler().execute(context, operation, resultHandler);
            return handlerResult;
        }
    }

    public static class ReadAttributeHandler
    implements ModelQueryOperationHandler {
        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            void var4_6;
            BasicOperationResult basicOperationResult = new BasicOperationResult();
            String attributeName = operation.require("name").asString();
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            AttributeAccess attributeAccess = context.getRegistry().getAttributeAccess(address, attributeName);
            if (attributeAccess == null) {
                Set<String> children = context.getRegistry().getChildNames(address);
                if (children.contains(attributeName)) {
                    throw new OperationFailedException(new ModelNode().set(String.format("'%s' is a registered child of resource (%s)", attributeName, address)));
                }
                if (!context.getSubModel().has(attributeName)) throw new OperationFailedException(new ModelNode().set("No known attribute called " + attributeName));
                ModelNode result = context.getSubModel().get(attributeName).clone();
                resultHandler.handleResultFragment(Util.NO_LOCATION, result);
                resultHandler.handleResultComplete();
                return var4_6;
            } else if (attributeAccess.getReadHandler() == null) {
                ModelNode result = context.getSubModel().get(attributeName).clone();
                resultHandler.handleResultFragment(Util.NO_LOCATION, result);
                resultHandler.handleResultComplete();
                return var4_6;
            } else {
                OperationResult operationResult = attributeAccess.getReadHandler().execute(context, operation, resultHandler);
            }
            return var4_6;
        }
    }

    public static class ReadResourceHandler
    implements ModelQueryOperationHandler {
        static final String PROXIES = "proxies";

        @Override
        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress(operation.get("address"));
            ModelNode result = this.readModel(context, operation, resultHandler, address);
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }

        protected ModelNode readModel(OperationContext context, ModelNode readOperation, final ResultHandler resultHandler, PathAddress address) throws OperationFailedException {
            ModelNode result;
            ModelNodeRegistration registry = context.getRegistry();
            ModelNode model = context.getSubModel(address);
            if (readOperation.get("recursive").asBoolean(false)) {
                result = model.clone();
                if (readOperation.get(PROXIES).asBoolean(true)) {
                    this.addProxyNodes(context, address, readOperation, result, registry);
                }
            } else {
                result = new ModelNode();
                Set<String> childNames = registry.getChildNames(address);
                ModelNode subModel = model.clone();
                for (String key : subModel.keys()) {
                    ModelNode child = subModel.get(key);
                    if (childNames.contains(key)) {
                        if (subModel.get(key).isDefined()) {
                            for (String childKey : child.keys()) {
                                subModel.get(new String[]{key, childKey}).set(new ModelNode());
                            }
                        }
                        result.get(key).set(child);
                        continue;
                    }
                    result.get(key).set(child);
                }
                boolean queryRuntime = readOperation.get("include-runtime").asBoolean(false);
                Set<String> attributeNames = registry.getAttributeNames(address);
                for (final String attributeName : attributeNames) {
                    AttributeAccess access = registry.getAttributeAccess(address, attributeName);
                    if (access == null) continue;
                    AttributeAccess.Storage storage = access.getStorageType();
                    if (!queryRuntime && storage != AttributeAccess.Storage.CONFIGURATION) continue;
                    final AttributeAccess.AccessType type = access.getAccessType();
                    OperationHandler handler = access.getReadHandler();
                    if (handler == null) continue;
                    ModelNode attributeOperation = readOperation.clone();
                    attributeOperation.get("name").set(attributeName);
                    handler.execute(context, attributeOperation, new ResultHandler(){

                        @Override
                        public void handleResultFragment(String[] location, ModelNode attributeResult) {
                            result.get(attributeName).set(attributeResult);
                        }

                        @Override
                        public void handleResultComplete() {
                        }

                        @Override
                        public void handleFailed(ModelNode failureDescription) {
                            if (type != AttributeAccess.AccessType.METRIC) {
                                resultHandler.handleFailed(failureDescription);
                            }
                        }

                        @Override
                        public void handleCancellation() {
                            resultHandler.handleCancellation();
                        }
                    });
                }
                this.handleNonRecursiveProxyEntries(context, address, readOperation, result, registry);
            }
            return result;
        }

        protected void handleNonRecursiveProxyEntries(OperationContext context, PathAddress address, ModelNode originalOperation, ModelNode result, ModelNodeRegistration registry) {
        }

        protected void addProxyNodes(OperationContext context, PathAddress address, ModelNode originalOperation, ModelNode result, ModelNodeRegistration registry) {
            Set<ProxyController> proxyControllers = registry.getProxyControllers(address);
            if (proxyControllers.size() > 0) {
                ModelNode operation = new ModelNode();
                operation.get("operation").set("read-resource");
                operation.get("recursive").set(true);
                operation.get("address").set(new ModelNode());
                for (ProxyController proxyController : proxyControllers) {
                    ModelNode proxyResult = proxyController.execute(OperationBuilder.Factory.copy((OperationAttachments)context, (ModelNode)operation).build());
                    PathAddress proxyAddress = proxyController.getProxyNodeAddress();
                    this.addProxyResultToMainResult(proxyAddress, result, proxyResult);
                }
            }
        }

        protected void addProxyResultToMainResult(PathAddress address, ModelNode mainResult, ModelNode proxyResult) {
            ModelNode resultNode = mainResult;
            for (PathElement element : address) {
                resultNode = resultNode.get(element.getKey()).get(element.getValue());
            }
            resultNode.set(proxyResult.get("result").clone());
        }
    }
}

