/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.as.controller.operations.common.SocketBindingGroupIncludeAddHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SocketBindingGroupIncludeRemoveHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove-included-group";
    public static final SocketBindingGroupIncludeRemoveHandler INSTANCE = new SocketBindingGroupIncludeRemoveHandler();
    private final ParameterValidator typeValidator = new ModelTypeValidator(ModelType.STRING);

    public static ModelNode getOperation(ModelNode address, String group) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("include").set(group);
        return op;
    }

    private SocketBindingGroupIncludeRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode param = operation.get("include");
        ModelNode includes = context.getSubModel().get("include");
        ModelNode toRemove = null;
        this.typeValidator.validateParameter("include", param);
        ModelNode newList = new ModelNode().setEmptyList();
        String group = param.asString();
        if (includes.isDefined()) {
            for (ModelNode included : includes.asList()) {
                if (group.equals(included.asString())) continue;
                toRemove = newList.add(included);
                break;
            }
        }
        if (toRemove != null) {
            ModelNode compensating = SocketBindingGroupIncludeAddHandler.getOperation(operation.get("address"), group);
            includes.set(newList);
            resultHandler.handleResultComplete();
            return new BasicOperationResult(compensating);
        }
        throw new OperationFailedException(new ModelNode().set("No included group with name " + group + "found"));
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getRemoveSocketBindingGroupIncludeOperation(locale);
    }
}

