/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.NamespaceRemoveHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class NamespaceAddHandler
implements ModelUpdateOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add-namespace";
    public static final NamespaceAddHandler INSTANCE = new NamespaceAddHandler();
    private final ParameterValidator typeValidator = new ModelTypeValidator(ModelType.PROPERTY);

    public static ModelNode getAddNamespaceOperation(ModelNode address, Property namespace) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("namespace").set(namespace);
        return op;
    }

    private NamespaceAddHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode param = operation.get("namespace");
        ModelNode namespaces = context.getSubModel().get("namespaces");
        this.validate(param, namespaces);
        Property prop = param.asProperty();
        namespaces.add(prop.getName(), prop.getValue());
        ModelNode compensating = NamespaceRemoveHandler.getRemoveNamespaceOperation(operation.get("address"), param.asProperty().getName());
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddNamespaceOperation(locale);
    }

    private void validate(ModelNode param, ModelNode namespaces) throws OperationFailedException {
        this.typeValidator.validateParameter("namespace", param);
        String name = param.asProperty().getName();
        if (namespaces.isDefined()) {
            for (ModelNode node : namespaces.asList()) {
                if (!name.equals(node.asProperty().getName())) continue;
                throw new OperationFailedException(new ModelNode().set("Namespace with prefix " + name + " already registered with schema URI " + node.asProperty().getValue().asString()));
            }
        }
    }
}

