/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.InputStream;
import java.util.List;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.dmr.ModelNode;

public class OperationContextImpl
implements OperationContext {
    private final ModelController controller;
    private final ModelNodeRegistration registry;
    private final ModelNode subModel;
    private final ModelProvider modelProvider;
    private final OperationAttachments executionAttachments;

    public OperationContextImpl(ModelController controller, ModelNodeRegistration registry, ModelNode subModel, ModelProvider modelProvider, OperationAttachments executionAttachments) {
        this.controller = controller;
        this.registry = registry;
        this.subModel = subModel;
        this.modelProvider = modelProvider;
        this.executionAttachments = executionAttachments;
    }

    @Override
    public ModelController getController() {
        return this.controller;
    }

    @Override
    public ModelNodeRegistration getRegistry() {
        return this.registry;
    }

    @Override
    public ModelNode getSubModel() {
        ModelNode subModel = this.subModel;
        if (subModel == null) {
            throw new IllegalArgumentException("Operation does not apply to a submodel");
        }
        return subModel;
    }

    @Override
    public ModelNode getSubModel(PathAddress address) throws IllegalArgumentException {
        ModelNode model = this.modelProvider.getModel();
        return address.navigate(model, false).clone();
    }

    @Override
    public RuntimeOperationContext getRuntimeContext() {
        return null;
    }

    public List<InputStream> getInputStreams() {
        return this.executionAttachments.getInputStreams();
    }
}

