/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class InterfaceAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final InterfaceAddHandler NAMED_INSTANCE = new InterfaceAddHandler(false);
    public static final InterfaceAddHandler SPECIFIED_INSTANCE = new InterfaceAddHandler(true);
    private final boolean specified;

    public static ModelNode getAddInterfaceOperation(ModelNode address, ModelNode criteria) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        op.get("criteria").set(criteria);
        return op;
    }

    protected InterfaceAddHandler(boolean specified) {
        this.specified = specified;
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        model.get("name").set(name);
        ModelNode criteriaNode = operation.get("criteria");
        ParsedInterfaceCriteria parsed = ParsedInterfaceCriteria.parse(criteriaNode.clone(), this.specified);
        if (parsed.getFailureMessage() != null) {
            throw new OperationFailedException(new ModelNode().set(parsed.getFailureMessage()));
        }
        model.get("criteria").set(criteriaNode);
        ModelNode compensating = Util.getResourceRemoveOperation(operation.get("address"));
        return this.installInterface(name, parsed, context, resultHandler, compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return this.specified ? InterfaceDescription.getSpecifiedInterfaceAddOperation(locale) : InterfaceDescription.getNamedInterfaceAddOperation(locale);
    }

    protected OperationResult installInterface(String name, ParsedInterfaceCriteria criteria, OperationContext context, ResultHandler resultHandler, ModelNode compensatingOp) {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

