/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class InterfaceDescription {
    private static final String RESOURCE_NAME = InterfaceDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getNamedInterfaceDescription(Locale locale) {
        ResourceBundle bundle = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("named_interface"));
        InterfaceDescription.populateInterface(root, bundle, false);
        return root;
    }

    public static ModelNode getSpecifiedInterfaceDescription(Locale locale) {
        ResourceBundle bundle = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("specified_interface"));
        InterfaceDescription.populateInterface(root, bundle, true);
        return root;
    }

    private static void populateInterface(ModelNode root, ResourceBundle bundle, boolean specified) {
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("interface.name"));
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "name", "head-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "name", "tail-comment-allowed"}).set(false);
        root.get(new String[]{"attributes", "criteria", "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"attributes", "criteria", "description"}).set(bundle.getString("interface.criteria"));
        root.get(new String[]{"attributes", "criteria", "required"}).set(specified);
        root.get(new String[]{"attributes", "criteria", "head-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "criteria", "tail-comment-allowed"}).set(false);
        root.get("operations").setEmptyObject();
    }

    public static ModelNode getNamedInterfaceAddOperation(Locale locale) {
        ResourceBundle bundle = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle.getString("interface.add"));
        root.get(new String[]{"request-properties", "criteria", "type"}).set(ModelType.OBJECT);
        root.get(new String[]{"request-properties", "criteria", "description"}).set(bundle.getString("interface.add.criteria"));
        root.get(new String[]{"request-properties", "criteria", "required"}).set(false);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSpecifiedInterfaceAddOperation(Locale locale) {
        ModelNode root = InterfaceDescription.getNamedInterfaceAddOperation(locale);
        root.get(new String[]{"request-properties", "criteria", "required"}).set(true);
        return root;
    }

    public static ModelNode getInterfaceRemoveOperation(Locale locale) {
        ResourceBundle bundle = InterfaceDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle.getString("interface.remove"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        ModelNode node = InterfaceDescription.getNamedInterfaceDescription(null);
        node.get(new String[]{"operations", "add"}).set(InterfaceDescription.getNamedInterfaceAddOperation(null));
        node.get(new String[]{"operations", "remove"}).set(InterfaceDescription.getInterfaceRemoveOperation(null));
        System.out.println(node);
        node = InterfaceDescription.getSpecifiedInterfaceDescription(null);
        node.get(new String[]{"operations", "add"}).set(InterfaceDescription.getSpecifiedInterfaceAddOperation(null));
        node.get(new String[]{"operations", "remove"}).set(InterfaceDescription.getInterfaceRemoveOperation(null));
        System.out.println(node);
    }
}

