/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.controller.persistence;

import java.io.OutputStream;
import java.util.List;

import org.jboss.dmr.ModelNode;

/**
 * The configuration persister for a model.
 *
 * @author <a href="mailto:david.lloyd@redhat.com">David M. Lloyd</a>
 */
public interface ConfigurationPersister {

    /**
     * Persist the given configuration model.
     *
     * @param model the model to persist
     */
    void store(ModelNode model) throws ConfigurationPersistenceException;

    /**
     * Marshals the given configuration model to XML, writing to the given stream.
     *
     * @param model  the model to persist
     * @param output the stream
     * @throws ConfigurationPersistenceException
     */
    void marshallAsXml(final ModelNode model, final OutputStream output) throws ConfigurationPersistenceException;

    /**
     * Load the configuration model, returning it as a list of updates to be
     * executed by the controller.
     */
    List<ModelNode> load() throws ConfigurationPersistenceException;
}
