/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationImpl;
import org.jboss.dmr.ModelNode;

public class OperationBuilder {
    private final ModelNode operation;
    private volatile List<InputStream> inputStreams;

    public OperationBuilder(ModelNode operation) {
        if (operation == null) {
            throw ControllerClientMessages.MESSAGES.nullVar("operation");
        }
        this.operation = operation;
    }

    public OperationBuilder addInputStream(InputStream in) {
        if (this.inputStreams == null) {
            this.inputStreams = new ArrayList<InputStream>();
        }
        this.inputStreams.add(in);
        return this;
    }

    public int getInputStreamCount() {
        List<InputStream> list = this.inputStreams;
        return list == null ? 0 : list.size();
    }

    public Operation build() {
        return new OperationImpl(this.operation, this.inputStreams);
    }
}

