/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationResult;
import org.jboss.as.controller.client.ResultHandler;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.client.helpers.domain.impl.DomainDeploymentManagerImpl;
import org.jboss.dmr.ModelNode;

public class DomainClientImpl
implements DomainClient {
    private volatile DomainDeploymentManager deploymentManager;
    private final ModelControllerClient delegate;

    public DomainClientImpl(InetAddress address, int port) {
        this.delegate = ModelControllerClient.Factory.create(address, port);
    }

    @Override
    public OperationResult execute(ModelNode operation, ResultHandler handler) {
        return this.execute(OperationBuilder.Factory.create(operation).build(), handler);
    }

    @Override
    public ModelNode execute(ModelNode operation) throws CancellationException, IOException {
        return this.execute(OperationBuilder.Factory.create(operation).build());
    }

    @Override
    public OperationResult execute(Operation operation, ResultHandler handler) {
        return this.delegate.execute(operation, handler);
    }

    @Override
    public ModelNode execute(Operation operation) throws CancellationException, IOException {
        return this.delegate.execute(operation);
    }

    @Override
    public byte[] addDeploymentContent(InputStream stream) {
        ModelNode op = new ModelNode();
        op.get("operation").set("upload-deployment-stream");
        op.get("input-stream-index").set(0);
        Operation operation = OperationBuilder.Factory.create(op).addInputStream(stream).build();
        ModelNode result = this.executeForResult(operation);
        return result.asBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomainDeploymentManager getDeploymentManager() {
        if (this.deploymentManager == null) {
            DomainClientImpl domainClientImpl = this;
            synchronized (domainClientImpl) {
                if (this.deploymentManager == null) {
                    this.deploymentManager = new DomainDeploymentManagerImpl(this);
                }
            }
        }
        return this.deploymentManager;
    }

    @Override
    public List<String> getHostControllerNames() {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("host");
        ModelNode result = this.executeForResult(OperationBuilder.Factory.create(op).build());
        ArrayList<String> hosts = new ArrayList<String>();
        for (ModelNode host : result.asList()) {
            hosts.add(host.asString());
        }
        return hosts;
    }

    @Override
    public Map<ServerIdentity, ServerStatus> getServerStatuses() {
        HashMap<ServerIdentity, ServerStatus> result = new HashMap<ServerIdentity, ServerStatus>();
        List<String> hosts = this.getHostControllerNames();
        for (String host : hosts) {
            Set<String> servers = this.getServerNames(host);
            for (String server : servers) {
                ModelNode address = new ModelNode();
                address.add("host", host);
                address.add("server-config", server);
                String group = this.readAttribute("group", address).asString();
                ServerStatus status = Enum.valueOf(ServerStatus.class, this.readAttribute("status", address).asString());
                ServerIdentity id = new ServerIdentity(host, group, server);
                result.put(id, status);
            }
        }
        return result;
    }

    private Set<String> getServerNames(String host) {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("server-config");
        op.get("address").add("host", host);
        ModelNode result = this.executeForResult(OperationBuilder.Factory.create(op).build());
        HashSet<String> servers = new HashSet<String>();
        for (ModelNode server : result.asList()) {
            servers.add(server.asString());
        }
        return servers;
    }

    private ModelNode readAttribute(String name, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(address);
        op.get("name").set(name);
        return this.executeForResult(OperationBuilder.Factory.create(op).build());
    }

    @Override
    public ServerStatus startServer(String hostControllerName, String serverName) {
        ModelNode op = new ModelNode();
        op.get("operation").set("start");
        ModelNode address = op.get("address");
        address.add("host", hostControllerName);
        address.add("server-config", serverName);
        ModelNode result = this.executeForResult(OperationBuilder.Factory.create(op).build());
        String status = result.asString();
        return Enum.valueOf(ServerStatus.class, status);
    }

    @Override
    public ServerStatus stopServer(String hostControllerName, String serverName, long gracefulShutdownTimeout, TimeUnit timeUnit) {
        ModelNode op = new ModelNode();
        op.get("operation").set("stop");
        ModelNode address = op.get("address");
        address.add("host", hostControllerName);
        address.add("server-config", serverName);
        ModelNode result = this.executeForResult(OperationBuilder.Factory.create(op).build());
        String status = result.asString();
        return Enum.valueOf(ServerStatus.class, status);
    }

    @Override
    public ServerStatus restartServer(String hostControllerName, String serverName, long gracefulShutdownTimeout, TimeUnit timeUnit) {
        ModelNode op = new ModelNode();
        op.get("operation").set("restart");
        ModelNode address = op.get("address");
        address.add("host", hostControllerName);
        address.add("server-config", serverName);
        ModelNode result = this.executeForResult(OperationBuilder.Factory.create(op).build());
        String status = result.asString();
        return Enum.valueOf(ServerStatus.class, status);
    }

    boolean isDeploymentNameUnique(String deploymentName) {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("deployment");
        ModelNode result = this.executeForResult(OperationBuilder.Factory.create(op).build());
        HashSet<String> deploymentNames = new HashSet<String>();
        if (result.isDefined()) {
            for (ModelNode node : result.asList()) {
                deploymentNames.add(node.asString());
            }
        }
        return !deploymentNames.contains(deploymentName);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    ModelNode executeForResult(Operation op) {
        try {
            ModelNode result = this.delegate.execute(op);
            if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
                return result.get("result");
            }
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            if (result.hasDefined("domain-failure-description")) {
                throw new RuntimeException(result.get("domain-failure-description").toString());
            }
            if (result.hasDefined("host-failure-descriptions")) {
                throw new RuntimeException(result.get("host-failure-descriptions").toString());
            }
            throw new RuntimeException("Operation outcome is " + result.get("outcome").asString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

