/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import org.jboss.as.controller.client.EstablishConnectionModelControllerClient;
import org.jboss.as.controller.client.ExistingConnectionModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationResult;
import org.jboss.as.controller.client.ResultHandler;
import org.jboss.as.protocol.Connection;
import org.jboss.dmr.ModelNode;

public interface ModelControllerClient
extends Closeable {
    public OperationResult execute(ModelNode var1, ResultHandler var2);

    public ModelNode execute(ModelNode var1) throws CancellationException, IOException;

    public OperationResult execute(Operation var1, ResultHandler var2);

    public ModelNode execute(Operation var1) throws CancellationException, IOException;

    public static class Factory {
        public static ModelControllerClient create(String hostName, int port) throws UnknownHostException {
            return Factory.create(InetAddress.getByName(hostName), port);
        }

        public static ModelControllerClient create(InetAddress address, int port) {
            return new EstablishConnectionModelControllerClient(address, port);
        }

        public static ModelControllerClient create(Connection connection) {
            return new ExistingConnectionModelControllerClient(connection);
        }
    }
}

