/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.cli.util.StrictSizeTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DeploymentInfoHandler
extends BaseOperationCommand {
    private final ArgumentWithValue name = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public Collection<String> getAllCandidates(CommandContext ctx) {
            return Util.getDeployments(ctx.getModelControllerClient());
        }
    }), "--name");
    private List<String> addedServerGroups;
    private List<String> otherServerGroups;

    public DeploymentInfoHandler(CommandContext ctx) {
        super(ctx, "deployment-info", true);
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        if (!this.name.isPresent(parsedCmd)) {
            throw new CommandFormatException("Required argument " + this.name.getFullName() + " is missing.");
        }
        String deploymentName = this.name.getValue(parsedCmd);
        ModelNode request = new ModelNode();
        if (ctx.isDomainMode()) {
            ModelNode response;
            List<String> serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
            this.addedServerGroups = null;
            this.otherServerGroups = null;
            ModelNode validateRequest = new ModelNode();
            validateRequest.get("operation").set("composite");
            validateRequest.get("address").setEmptyList();
            ModelNode steps = validateRequest.get("steps");
            for (String serverGroup : serverGroups) {
                ModelNode step = new ModelNode();
                step.get("address").setEmptyList();
                step.get("operation").set("validate-address");
                ModelNode value = step.get("value");
                value.add("server-group", serverGroup);
                value.add("deployment", deploymentName);
                steps.add(step);
            }
            ModelControllerClient client = ctx.getModelControllerClient();
            try {
                response = client.execute(validateRequest);
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to query server groups for deployment " + deploymentName, e);
            }
            if (!response.hasDefined("result")) {
                throw new CommandFormatException("The validation response came back w/o result: " + response);
            }
            ModelNode result = response.get("result");
            if (result.hasDefined("domain-results")) {
                result = result.get("domain-results");
            }
            List stepResponses = result.asPropertyList();
            for (int i = 0; i < serverGroups.size(); ++i) {
                Property prop = (Property)stepResponses.get(i);
                ModelNode stepResponse = prop.getValue();
                if (stepResponse.has(prop.getName())) {
                    stepResponse = stepResponse.get(prop.getName());
                }
                if (stepResponse.hasDefined("result")) {
                    ModelNode stepResult = stepResponse.get("result");
                    if (stepResult.hasDefined("valid") && stepResult.get("valid").asBoolean()) {
                        if (this.addedServerGroups == null) {
                            this.addedServerGroups = new ArrayList<String>();
                        }
                        this.addedServerGroups.add(serverGroups.get(i));
                        continue;
                    }
                    if (this.otherServerGroups == null) {
                        this.otherServerGroups = new ArrayList<String>();
                    }
                    this.otherServerGroups.add(serverGroups.get(i));
                    continue;
                }
                if (this.otherServerGroups == null) {
                    this.otherServerGroups = new ArrayList<String>();
                }
                this.otherServerGroups.add(serverGroups.get(i));
            }
            request.get("operation").set("composite");
            request.get("address").setEmptyList();
            ModelNode steps2 = request.get("steps");
            ModelNode step = new ModelNode();
            ModelNode address = step.get("address");
            address.add("deployment", deploymentName);
            step.get("operation").set("read-resource");
            steps2.add(step);
            if (this.addedServerGroups != null) {
                for (String serverGroup : this.addedServerGroups) {
                    step = new ModelNode();
                    address = step.get("address");
                    address.add("server-group", serverGroup);
                    address.add("deployment", deploymentName);
                    step.get("operation").set("read-resource");
                    steps2.add(step);
                }
            }
        } else {
            ModelNode address = request.get("address");
            address.add("deployment", deploymentName);
            request.get("operation").set("read-resource");
            request.get("include-runtime").set(true);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandFormatException {
        try {
            if (!response.hasDefined("result")) {
                throw new CommandFormatException("The operation response came back w/o result: " + response);
            }
            ModelNode result = response.get("result");
            if (ctx.isDomainMode()) {
                Iterator steps;
                if (result.hasDefined("domain-results")) {
                    result = result.get("domain-results");
                }
                if (!(steps = result.asPropertyList().iterator()).hasNext()) {
                    throw new CommandFormatException("Response for the main resource info of the deployment is missing: " + result);
                }
                ModelNode step = ((Property)steps.next()).getValue();
                if (step.has("step-1")) {
                    step = step.get("step-1");
                }
                if (!step.has("result")) {
                    throw new CommandFormatException("Failed to read the main resource info of the deployment: " + Util.getFailureDescription(step));
                }
                ModelNode stepResponse = step.get("result");
                StrictSizeTable table = new StrictSizeTable(1);
                table.addCell("name", stepResponse.get("name").asString());
                table.addCell("runtime-name", stepResponse.get("runtime-name").asString());
                ctx.printLine(table.toString());
                SimpleTable groups = new SimpleTable(new String[]{"SERVER GROUP", "STATE"});
                if (this.addedServerGroups == null) {
                    if (steps.hasNext()) {
                        throw new CommandFormatException("Didn't expect results for server groups but received " + (result.asPropertyList().size() - 1) + " more steps.");
                    }
                } else {
                    for (String sg : this.addedServerGroups) {
                        Property prop = (Property)steps.next();
                        stepResponse = prop.getValue();
                        if (stepResponse.has(prop.getName())) {
                            stepResponse = stepResponse.get(prop.getName());
                        }
                        if (stepResponse.hasDefined("result")) {
                            ModelNode stepResult = stepResponse.get("result");
                            if (stepResult.hasDefined("enabled")) {
                                groups.addLine(new String[]{sg, stepResult.get("enabled").asBoolean() ? "enabled" : "added"});
                                continue;
                            }
                            groups.addLine(new String[]{sg, "n/a"});
                            continue;
                        }
                        groups.addLine(new String[]{sg, "no response"});
                    }
                }
                if (this.otherServerGroups != null) {
                    for (String sg : this.otherServerGroups) {
                        groups.addLine(new String[]{sg, "not added"});
                    }
                }
                ctx.printLine(groups.toString(true));
            } else {
                StrictSizeTable table = new StrictSizeTable(1);
                table.addCell("name", result.get("name").asString());
                table.addCell("runtime-name", result.get("runtime-name").asString());
                table.addCell("persistent", result.get("persistent").asString());
                table.addCell("enabled", result.get("enabled").asString());
                table.addCell("status", result.get("status").asString());
                ctx.printLine(table.toString());
            }
        }
        finally {
            this.addedServerGroups = null;
            this.otherServerGroups = null;
        }
    }
}

