/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.SecurityActions;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class VersionHandler
implements CommandHandler {
    public static final VersionHandler INSTANCE = new VersionHandler();

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return true;
    }

    @Override
    public boolean isBatchMode(CommandContext ctx) {
        return false;
    }

    @Override
    public void handle(CommandContext ctx) {
        StringBuilder buf = new StringBuilder();
        buf.append("JBoss Admin Command-line Interface\n");
        buf.append("JBOSS_HOME: ").append(SecurityActions.getEnvironmentVariable("JBOSS_HOME")).append('\n');
        buf.append("JBoss AS release: ");
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            buf.append("<connect to the controller and re-run the version command to see the release info>\n");
        } else {
            ModelNode req = new ModelNode();
            req.get("operation").set("read-resource");
            req.get("address").setEmptyList();
            try {
                ModelNode response = client.execute(req);
                if (Util.isSuccess(response)) {
                    if (response.hasDefined("result")) {
                        ModelNode result = response.get("result");
                        int flag = 0;
                        if (result.hasDefined("release-version")) {
                            buf.append(result.get("release-version").asString());
                            flag = (byte)(flag + 1);
                        }
                        if (result.hasDefined("release-codename")) {
                            buf.append(" \"").append(result.get("release-codename").asString()).append('\"');
                            flag = (byte)(flag + 1);
                        }
                        if (flag == 0) {
                            buf.append("release info was not provided by the controller");
                        }
                    } else {
                        buf.append("result was not available.");
                    }
                } else {
                    buf.append(Util.getFailureDescription(response));
                }
                buf.append('\n');
            }
            catch (IOException e) {
                ctx.error("Failed to get the AS release info: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        buf.append("JAVA_HOME: ").append(SecurityActions.getEnvironmentVariable("JAVA_HOME")).append('\n');
        buf.append("java.version: ").append(SecurityActions.getSystemProperty("java.version")).append('\n');
        buf.append("java.vm.vendor: ").append(SecurityActions.getSystemProperty("java.vm.vendor")).append('\n');
        buf.append("java.vm.version: ").append(SecurityActions.getSystemProperty("java.vm.version")).append('\n');
        buf.append("os.name: ").append(SecurityActions.getSystemProperty("os.name")).append('\n');
        buf.append("os.version: ").append(SecurityActions.getSystemProperty("os.version"));
        ctx.printLine(buf.toString());
    }

    @Override
    public boolean hasArgument(String name) {
        return false;
    }

    @Override
    public boolean hasArgument(int index) {
        return false;
    }

    public List<CommandArgument> getArguments(CommandContext ctx) {
        return Collections.emptyList();
    }
}

