/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.util.StrictSizeTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DeployHandler
extends BatchModeCommandHandler {
    private final ArgumentWithoutValue force;
    private final ArgumentWithoutValue l;
    private final ArgumentWithoutValue path;
    private final ArgumentWithoutValue name;
    private final ArgumentWithoutValue rtName;
    private final ArgumentWithValue serverGroups;
    private final ArgumentWithoutValue allServerGroups;
    private final ArgumentWithoutValue disabled;

    public DeployHandler(CommandContext ctx) {
        super(ctx, "deploy", true);
        DefaultOperationRequestAddress requiredAddress = new DefaultOperationRequestAddress();
        requiredAddress.toNodeType("deployment");
        this.addRequiredPath(requiredAddress);
        this.l = new ArgumentWithoutValue(this, "-l");
        this.l.setExclusive(true);
        final FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        this.path = new ArgumentWithValue(this, pathCompleter, 0, "--path"){

            @Override
            public String getValue(ParsedCommandLine args) {
                String value = super.getValue(args);
                if (value != null) {
                    if (value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    value = pathCompleter.translatePath(value);
                }
                return value;
            }
        };
        this.path.addCantAppearAfter(this.l);
        this.force = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--force", "-f");
        this.force.addRequiredPreceding(this.path);
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                ParsedCommandLine args = ctx.getParsedCommandLine();
                try {
                    if (DeployHandler.this.path.isPresent(args)) {
                        return -1;
                    }
                }
                catch (CommandFormatException e) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }, "--name");
        this.name.addCantAppearAfter(this.l);
        this.path.addCantAppearAfter(this.name);
        this.rtName = new ArgumentWithValue(this, "--runtime-name");
        this.rtName.addRequiredPreceding(this.path);
        this.allServerGroups = new ArgumentWithoutValue(this, "--all-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.allServerGroups.addRequiredPreceding(this.path);
        this.allServerGroups.addRequiredPreceding(this.name);
        this.allServerGroups.addCantAppearAfter(this.force);
        this.force.addCantAppearAfter(this.allServerGroups);
        this.serverGroups = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int result;
                String chunk;
                int lastGroupIndex;
                List<String> allGroups = Util.getServerGroups(ctx.getModelControllerClient());
                if (buffer.isEmpty()) {
                    candidates.addAll(allGroups);
                    Collections.sort(candidates);
                    return 0;
                }
                String[] groups = buffer.split(",+");
                if (buffer.charAt(buffer.length() - 1) == ',') {
                    lastGroupIndex = groups.length;
                    chunk = null;
                } else {
                    lastGroupIndex = groups.length - 1;
                    chunk = groups[groups.length - 1];
                }
                for (int i = 0; i < lastGroupIndex; ++i) {
                    allGroups.remove(groups[i]);
                }
                if (chunk == null) {
                    candidates.addAll(allGroups);
                    result = buffer.length();
                } else {
                    for (String group : allGroups) {
                        if (!group.startsWith(chunk)) continue;
                        candidates.add(group);
                    }
                    result = buffer.lastIndexOf(44) + 1;
                }
                Collections.sort(candidates);
                return result;
            }
        }, "--server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.serverGroups.addRequiredPreceding(this.path);
        this.serverGroups.addRequiredPreceding(this.name);
        this.serverGroups.addCantAppearAfter(this.force);
        this.force.addCantAppearAfter(this.serverGroups);
        this.serverGroups.addCantAppearAfter(this.allServerGroups);
        this.allServerGroups.addCantAppearAfter(this.serverGroups);
        this.disabled = new ArgumentWithoutValue(this, "--disabled");
        this.disabled.addRequiredPreceding(this.path);
        this.disabled.addCantAppearAfter(this.serverGroups);
        this.disabled.addCantAppearAfter(this.allServerGroups);
        this.disabled.addCantAppearAfter(this.force);
        this.force.addCantAppearAfter(this.disabled);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ModelNode steps;
        ModelNode deployRequest;
        String name;
        File f;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            this.listDeployments(ctx, l);
            return;
        }
        String path = this.path.getValue(args);
        if (path != null) {
            f = new File(path);
            if (!f.exists()) {
                ctx.error("Path " + f.getAbsolutePath() + " doesn't exist.");
                return;
            }
            if (f.isDirectory()) {
                ctx.error(f.getAbsolutePath() + " is a directory.");
                return;
            }
        } else {
            f = null;
        }
        if ((name = this.name.getValue(args)) == null) {
            if (f == null) {
                ctx.error("Either path or --name is requied.");
                return;
            }
            name = f.getName();
        }
        String runtimeName = this.rtName.getValue(args);
        boolean force = this.force.isPresent(args);
        boolean disabled = this.disabled.isPresent(args);
        String serverGroups = this.serverGroups.getValue(args);
        boolean allServerGroups = this.allServerGroups.isPresent(args);
        if (force) {
            if (f == null) {
                ctx.error(this.force.getFullName() + " requires a filesystem path of the deployment to be added to the deployment repository.");
                return;
            }
            if (disabled || serverGroups != null || allServerGroups) {
                ctx.error(this.force.getFullName() + " only replaces the content in the deployment repository and can't be used in combination with any of " + this.disabled.getFullName() + ", " + this.serverGroups.getFullName() + " or " + this.allServerGroups.getFullName() + '.');
                return;
            }
            if (Util.isDeploymentInRepository(name, client)) {
                this.replaceDeployment(ctx, f, name, runtimeName);
                return;
            }
            if (ctx.isDomainMode()) {
                ModelNode request = this.buildAddRequest(ctx, f, name, runtimeName);
                this.execute(ctx, request, f);
                return;
            }
        }
        if (disabled) {
            if (f == null) {
                ctx.error(this.disabled.getFullName() + " requires a filesystem path of the deployment to be added to the deployment repository.");
                return;
            }
            if (serverGroups != null || allServerGroups) {
                ctx.error(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't be used in combination with " + this.disabled.getFullName() + '.');
                return;
            }
            if (Util.isDeploymentInRepository(name, client)) {
                ctx.error("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
                return;
            }
            ModelNode request = this.buildAddRequest(ctx, f, name, runtimeName);
            this.execute(ctx, request, f);
            return;
        }
        if (ctx.isDomainMode()) {
            List<String> sgList;
            if (allServerGroups) {
                if (serverGroups != null) {
                    ctx.error(this.serverGroups.getFullName() + " can't appear in the same command with " + this.allServerGroups.getFullName());
                    return;
                }
                sgList = Util.getServerGroups(client);
                if (sgList.isEmpty()) {
                    ctx.error("No server group is available.");
                    return;
                }
            } else {
                if (serverGroups == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("One of ");
                    if (f != null) {
                        buf.append(this.disabled.getFullName()).append(", ");
                    }
                    buf.append(this.allServerGroups.getFullName() + " or " + this.serverGroups.getFullName() + " is missing.");
                    ctx.error(buf.toString());
                    return;
                }
                sgList = Arrays.asList(serverGroups.split(","));
                if (sgList.isEmpty()) {
                    ctx.error("Couldn't locate server group name in '" + this.serverGroups.getFullName() + "=" + serverGroups + "'.");
                    return;
                }
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("composite");
            deployRequest.get("address").setEmptyList();
            steps = deployRequest.get("steps");
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
            }
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
            }
        } else {
            if (serverGroups != null || allServerGroups) {
                ctx.error(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't appear in standalone mode.");
                return;
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("deploy");
            deployRequest.get(new String[]{"address", "deployment"}).set(name);
        }
        if (f != null) {
            if (Util.isDeploymentInRepository(name, client)) {
                ctx.error("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
                return;
            }
            ModelNode request = new ModelNode();
            request.get("operation").set("composite");
            request.get("address").setEmptyList();
            steps = request.get("steps");
            steps.add(this.buildAddRequest(ctx, f, name, runtimeName));
            steps.add(deployRequest);
            this.execute(ctx, request, f);
            return;
        }
        if (!Util.isDeploymentInRepository(name, client)) {
            ctx.error("'" + name + "' is not found among the registered deployments.");
            return;
        }
        try {
            ModelNode result = client.execute(deployRequest);
            if (!Util.isSuccess(result)) {
                ctx.error(Util.getFailureDescription(result));
                return;
            }
        }
        catch (Exception e) {
            ctx.error("Failed to deploy: " + e.getLocalizedMessage());
            return;
        }
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        ModelNode addRequest;
        ModelNode deployRequest;
        String name;
        File f;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            throw new OperationFormatException("Command is missing arguments for non-interactive mode: '" + args.getOriginalLine() + "'.");
        }
        String path = this.path.getValue(args);
        if (path != null) {
            f = new File(path);
            if (!f.exists()) {
                throw new OperationFormatException("Path " + f.getAbsolutePath() + " doesn't exist.");
            }
            if (f.isDirectory()) {
                throw new OperationFormatException(f.getAbsolutePath() + " is a directory.");
            }
        } else {
            f = null;
        }
        if ((name = this.name.getValue(args)) == null) {
            if (f == null) {
                throw new OperationFormatException("Either path or --name is requied.");
            }
            name = f.getName();
        }
        String runtimeName = this.rtName.getValue(args);
        boolean force = this.force.isPresent(args);
        boolean disabled = this.disabled.isPresent(args);
        String serverGroups = this.serverGroups.getValue(args);
        boolean allServerGroups = this.allServerGroups.isPresent(args);
        if (force) {
            if (f == null) {
                throw new OperationFormatException(this.force.getFullName() + " requires a filesystem path of the deployment to be added to the deployment repository.");
            }
            if (disabled || serverGroups != null || allServerGroups) {
                throw new OperationFormatException(this.force.getFullName() + " only replaces the content in the deployment repository and can't be used in combination with any of " + this.disabled.getFullName() + ", " + this.serverGroups.getFullName() + " or " + this.allServerGroups.getFullName() + '.');
            }
            if (Util.isDeploymentInRepository(name, client)) {
                return this.buildDeploymentReplace(f, name, runtimeName);
            }
            return this.buildDeploymentAdd(f, name, runtimeName);
        }
        if (disabled) {
            if (f == null) {
                throw new OperationFormatException(this.disabled.getFullName() + " requires a filesystem path of the deployment to be added to the deployment repository.");
            }
            if (serverGroups != null || allServerGroups) {
                throw new OperationFormatException(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't be used in combination with " + this.disabled.getFullName() + '.');
            }
            if (Util.isDeploymentInRepository(name, client)) {
                throw new OperationFormatException("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
            }
            return this.buildDeploymentAdd(f, name, runtimeName);
        }
        if (ctx.isDomainMode()) {
            List<String> sgList;
            if (allServerGroups) {
                if (serverGroups != null) {
                    throw new OperationFormatException(this.serverGroups.getFullName() + " can't appear in the same command with " + this.allServerGroups.getFullName());
                }
                sgList = Util.getServerGroups(client);
                if (sgList.isEmpty()) {
                    throw new OperationFormatException("No server group is available.");
                }
            } else {
                if (serverGroups == null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("One of ");
                    if (f != null) {
                        buf.append(this.disabled.getFullName()).append(", ");
                    }
                    buf.append(this.allServerGroups.getFullName() + " or " + this.serverGroups.getFullName() + " is missing.");
                    throw new OperationFormatException(buf.toString());
                }
                sgList = Arrays.asList(serverGroups.split(","));
                if (sgList.isEmpty()) {
                    throw new OperationFormatException("Couldn't locate server group name in '" + this.serverGroups.getFullName() + "=" + serverGroups + "'.");
                }
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("composite");
            deployRequest.get("address").setEmptyList();
            ModelNode steps = deployRequest.get("steps");
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("add", name, serverGroup));
            }
            for (String serverGroup : sgList) {
                steps.add(Util.configureDeploymentOperation("deploy", name, serverGroup));
            }
        } else {
            if (serverGroups != null || allServerGroups) {
                throw new OperationFormatException(this.serverGroups.getFullName() + " and " + this.allServerGroups.getFullName() + " can't appear in standalone mode.");
            }
            deployRequest = new ModelNode();
            deployRequest.get("operation").set("deploy");
            deployRequest.get(new String[]{"address", "deployment"}).set(name);
        }
        if (f != null) {
            if (Util.isDeploymentInRepository(name, client)) {
                throw new OperationFormatException("'" + name + "' already exists in the deployment repository (use " + this.force.getFullName() + " to replace the existing content in the repository).");
            }
            addRequest = this.buildDeploymentAdd(f, name, runtimeName);
        } else {
            if (!Util.isDeploymentInRepository(name, client)) {
                throw new OperationFormatException("'" + name + "' is not found among the registered deployments.");
            }
            addRequest = null;
        }
        if (addRequest != null) {
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            steps.add(addRequest);
            steps.add(deployRequest);
            return composite;
        }
        return deployRequest;
    }

    protected ModelNode buildDeploymentReplace(File f, String name, String runtimeName) throws OperationFormatException {
        ModelNode request = new ModelNode();
        request.get("operation").set("full-replace-deployment");
        request.get("name").set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        byte[] bytes = this.readBytes(f);
        request.get("content").get(0).get("bytes").set(bytes);
        return request;
    }

    protected ModelNode buildDeploymentAdd(File f, String name, String runtimeName) throws OperationFormatException {
        ModelNode request = new ModelNode();
        request.get("operation").set("add");
        request.get(new String[]{"address", "deployment"}).set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        byte[] bytes = this.readBytes(f);
        request.get("content").get(0).get("bytes").set(bytes);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(CommandContext ctx, ModelNode request, File f) {
        ModelNode result;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            OperationBuilder op = new OperationBuilder(request);
            op.addInputStream((InputStream)is);
            request.get("content").get(0).get("input-stream-index").set(0);
            result = ctx.getModelControllerClient().execute(op.build());
        }
        catch (Exception e) {
            try {
                ctx.error("Failed to add the deployment content to the repository: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)is);
            return;
        }
        StreamUtils.safeClose((Closeable)is);
        if (!Util.isSuccess(result)) {
            ctx.error(Util.getFailureDescription(result));
            return;
        }
    }

    protected ModelNode buildAddRequest(CommandContext ctx, File f, String name, String runtimeName) {
        ModelNode request = new ModelNode();
        request.get("operation").set("add");
        request.get(new String[]{"address", "deployment"}).set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        request.get("content").get(0).get("input-stream-index").set(0);
        return request;
    }

    protected void replaceDeployment(CommandContext ctx, File f, String name, String runtimeName) {
        ModelNode request = new ModelNode();
        request.get("operation").set("full-replace-deployment");
        request.get("name").set(name);
        if (runtimeName != null) {
            request.get("runtime-name").set(runtimeName);
        }
        request.get("content").get(0).get("input-stream-index").set(0);
        this.execute(ctx, request, f);
    }

    protected byte[] readBytes(File f) throws OperationFormatException {
        byte[] bytes;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            bytes = new byte[(int)f.length()];
            int read = is.read(bytes);
            if (read != bytes.length) {
                throw new OperationFormatException("Failed to read bytes from " + f.getAbsolutePath() + ": " + read + " from " + f.length());
            }
        }
        catch (Exception e) {
            try {
                throw new OperationFormatException("Failed to read file " + f.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)is);
        return bytes;
    }

    protected void listDeployments(CommandContext ctx, boolean l) throws CommandFormatException {
        if (!l) {
            this.printList(ctx, Util.getDeployments(ctx.getModelControllerClient()), l);
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        List<String> names = Util.getDeployments(client);
        if (names.isEmpty()) {
            return;
        }
        StrictSizeTable table = new StrictSizeTable(names.size());
        List descriptions = this.getDeploymentDescriptions(ctx, names).asPropertyList();
        for (Property prop : descriptions) {
            ModelNode step = prop.getValue();
            if (step.hasDefined("result")) {
                ModelNode result = step.get("result");
                table.addCell("name", result.get("name").asString());
                table.addCell("runtime-name", result.get("runtime-name").asString());
                if (result.has("enabled")) {
                    table.addCell("enabled", result.get("enabled").asString());
                }
                if (result.has("status")) {
                    table.addCell("status", result.get("status").asString());
                }
            }
            if (table.isAtLastRow()) continue;
            table.nextRow();
        }
        ctx.error(table.toString());
    }

    protected ModelNode getDeploymentDescriptions(CommandContext ctx, List<String> names) throws CommandFormatException {
        ModelNode result;
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (String name : names) {
            ModelNode deploymentResource = this.buildReadDeploymentResourceRequest(name);
            if (deploymentResource == null) continue;
            steps.add(deploymentResource);
        }
        try {
            result = ctx.getModelControllerClient().execute(composite);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute operation request.", e);
        }
        if (!result.hasDefined("result")) {
            return null;
        }
        return result.get("result");
    }

    protected ModelNode buildReadDeploymentResourceRequest(String name) {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        address.add("deployment", name);
        request.get("operation").set("read-resource");
        request.get("include-runtime").set(true);
        return request;
    }
}

