/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.impl.RolloutPlanGroup;
import org.jboss.dmr.ModelNode;

public class SingleRolloutPlanGroup
implements RolloutPlanGroup {
    private String groupName;
    private Map<String, String> props;

    public SingleRolloutPlanGroup() {
    }

    public SingleRolloutPlanGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Invalid group name: " + groupName);
        }
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void addProperty(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid property value: " + value);
        }
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name, value);
    }

    @Override
    public ModelNode toModelNode() throws CommandFormatException {
        ModelNode node = new ModelNode();
        if (this.props != null) {
            for (String propName : this.props.keySet()) {
                node.get(propName).set(this.props.get(propName));
            }
        }
        return node;
    }

    @Override
    public void addTo(ModelNode inSeries) throws CommandFormatException {
        inSeries.add().get("server-group").get(this.groupName).set(this.toModelNode());
    }
}

