/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithoutValue;

public class HelpHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithoutValue commands = new ArgumentWithoutValue(this, "--commands");

    public HelpHandler() {
        this("help");
    }

    public HelpHandler(String command) {
        super(command);
        this.helpArg.setExclusive(false);
        this.helpArg.addCantAppearAfter(this.commands);
        this.helpArg.addRequiredPreceding(this.commands);
    }

    @Override
    public void handle(CommandContext ctx) {
        boolean printCommands;
        try {
            printCommands = this.commands.isPresent(ctx.getParsedCommandLine());
        }
        catch (CommandFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
            return;
        }
        if (printCommands) {
            ArrayList<String> commands = new ArrayList<String>();
            ctx.getDefaultCommandCompleter().complete(ctx, "", 0, commands);
            ctx.printLine("Commands available in the current context:");
            ctx.printColumns(commands);
            ctx.printLine("To read a description of a specific command execute 'command_name --help'.");
        } else {
            this.printHelp(ctx);
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) {
    }
}

