/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    protected static void addShutdownHook(Thread hook) {
        TCLAction.UTIL.addShutdownHook(hook);
    }

    protected static String getSystemProperty(String name) {
        return TCLAction.UTIL.getSystemProperty(name);
    }

    protected static ClassLoader getClassLoader(Class<?> cls) {
        return TCLAction.UTIL.getClassLoader(cls);
    }

    private static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            @Override
            public void addShutdownHook(Thread t) {
                Runtime.getRuntime().addShutdownHook(t);
            }

            @Override
            public String getSystemProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public ClassLoader getClassLoader(Class<?> cls) {
                return cls.getClassLoader();
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){

            @Override
            public void addShutdownHook(final Thread thread) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        Runtime.getRuntime().addShutdownHook(thread);
                        return null;
                    }
                });
            }

            @Override
            public String getSystemProperty(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty(name);
                    }
                });
            }

            @Override
            public ClassLoader getClassLoader(final Class<?> cls) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return cls.getClassLoader();
                    }
                });
            }
        };

        public void addShutdownHook(Thread var1);

        public ClassLoader getClassLoader(Class<?> var1);

        public String getSystemProperty(String var1);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static void addShutdownHook(Thread hook) {
                UTIL.getTCLAction().addShutdownHook(hook);
            }

            public static String getSystemProperty(String name) {
                return UTIL.getTCLAction().getSystemProperty(name);
            }

            public static ClassLoader getClassLoader(Class<?> cls) {
                return UTIL.getTCLAction().getClassLoader(cls);
            }
        }
    }
}

