/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.RequestParameterArgument;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public abstract class BaseOperationCommand
extends CommandHandlerWithHelp
implements OperationCommand {
    protected List<RequestParameterArgument> params = new ArrayList<RequestParameterArgument>();
    protected OperationRequestAddress requiredAddress;

    public BaseOperationCommand(String command) {
        super(command, true);
    }

    public BaseOperationCommand(String command, boolean connectionRequired) {
        super(command, connectionRequired);
    }

    protected void addRequiredPath(String requiredPath) {
        if (requiredPath == null) {
            throw new IllegalArgumentException("Required path can't be null.");
        }
        if (this.requiredAddress != null) {
            throw new IllegalStateException("Only one required address is allowed, atm.");
        }
        this.requiredAddress = new DefaultOperationRequestAddress();
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(this.requiredAddress);
        try {
            DefaultOperationRequestParser.INSTANCE.parse(requiredPath, handler);
        }
        catch (CommandFormatException e) {
            throw new IllegalArgumentException("Failed to parse nodeType: " + e.getMessage());
        }
    }

    protected void addRequiredPath(OperationRequestAddress requiredPath) {
        if (requiredPath == null) {
            throw new IllegalArgumentException("Required path can't be null.");
        }
        if (this.requiredAddress != null) {
            throw new IllegalStateException("Only one required address is allowed, atm.");
        }
        this.requiredAddress = requiredPath;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        ModelNode result;
        if (!super.isAvailable(ctx)) {
            return false;
        }
        if (this.requiredAddress == null) {
            return true;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return false;
        }
        if (ctx.isDomainMode()) {
            return true;
        }
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        for (OperationRequestAddress.Node node : this.requiredAddress) {
            address.add(node.getType(), node.getName());
        }
        request.get("operation").set("validate-address");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return false;
        }
        return Util.isSuccess(result);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (CommandFormatException e1) {
            ctx.printLine(e1.getLocalizedMessage());
            return;
        }
        if (request == null) {
            ctx.printLine("Operation request wasn't built.");
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
    }

    @Override
    public void addArgument(CommandArgument arg) {
        super.addArgument(arg);
        if (arg instanceof RequestParameterArgument) {
            this.params.add((RequestParameterArgument)arg);
        }
    }

    protected void setParams(CommandContext ctx, ModelNode request) throws CommandFormatException {
        for (RequestParameterArgument arg : this.params) {
            arg.set(ctx.getParsedArguments(), request);
        }
    }
}

