/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jca;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class SimpleDataSourceOperationHandler
extends BatchModeCommandHandler {
    protected final String dsType;
    protected final ArgumentWithValue profile;
    protected final ArgumentWithValue name;
    protected final ArgumentWithValue operation;

    public SimpleDataSourceOperationHandler(final String dsType) {
        super("data-source", true);
        this.dsType = dsType;
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                String profileArg;
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                if (!ctx.isDomainMode()) {
                    profileArg = null;
                } else {
                    profileArg = SimpleDataSourceOperationHandler.this.profile.getValue(ctx.getParsedArguments());
                    if (profileArg == null) {
                        return Collections.emptyList();
                    }
                }
                return Util.getDatasources(ctx.getModelControllerClient(), profileArg, dsType);
            }
        }), 0, "--name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !SimpleDataSourceOperationHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                StringBuilder buf = new StringBuilder();
                if (ctx.isDomainMode()) {
                    String profileName = SimpleDataSourceOperationHandler.this.profile.getValue(ctx.getParsedArguments());
                    if (SimpleDataSourceOperationHandler.this.profile == null) {
                        return -1;
                    }
                    buf.append("profile=").append(profileName);
                }
                buf.append("subsystem=datasources/").append(dsType).append('=');
                String dsName = SimpleDataSourceOperationHandler.this.name.getValue(ctx.getParsedArguments());
                if (dsName == null) {
                    return -1;
                }
                buf.append(Util.escapeString(dsName, OperationRequestCompleter.ESCAPE_SELECTOR)).append(':');
                int addressLength = buf.length();
                buf.append(buffer);
                int result = OperationRequestCompleter.INSTANCE.complete(ctx, buf.toString(), cursor += addressLength, candidates) - addressLength;
                return result;
            }
        }, 1, "--operation"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !SimpleDataSourceOperationHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation.addRequiredPreceding(this.name);
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(ctx.getParsedArguments());
            if (profile == null) {
                throw new OperationFormatException("Required argument --profile is missing.");
            }
            builder.addNode("profile", profile);
        }
        String name = this.name.getValue(ctx.getParsedArguments(), true);
        String operation = this.operation.getValue(ctx.getParsedArguments(), true);
        builder.addNode("subsystem", "datasources");
        builder.addNode(this.dsType, name);
        builder.setOperationName(operation);
        return builder.buildRequest();
    }
}

