/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;

public class SimpleTabCompleter
implements CommandLineCompleter {
    private final List<String> all;

    public SimpleTabCompleter(String[] candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException("Candidates can't be null");
        }
        this.all = Arrays.asList(candidates);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int result;
        String chunk;
        int nextCharIndex;
        for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
        }
        if (nextCharIndex == buffer.length()) {
            candidates.addAll(this.all);
            return nextCharIndex;
        }
        String[] split = buffer.split("\\s+");
        if (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
            chunk = null;
            result = buffer.length();
        } else {
            chunk = split[split.length - 1];
            for (result = buffer.length() - 1; result >= 0 && !Character.isWhitespace(buffer.charAt(result)); --result) {
            }
            ++result;
        }
        ArrayList<String> remainingArgs = new ArrayList<String>(this.all);
        int maxI = chunk == null ? split.length : split.length - 1;
        for (int i = 0; i < maxI; ++i) {
            String arg = split[i];
            int equalsIndex = arg.indexOf(61);
            if (equalsIndex >= 0) {
                arg = arg.substring(0, equalsIndex + 1);
            }
            remainingArgs.remove(arg);
        }
        if (chunk == null) {
            candidates.addAll(remainingArgs);
        } else {
            for (String name : remainingArgs) {
                if (!name.startsWith(chunk)) continue;
                candidates.add(name);
            }
            Collections.sort(candidates);
        }
        return result;
    }
}

