/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleterWithDelegate;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class DeployHandler
extends BatchModeCommandHandler {
    public DeployHandler() {
        super("deploy", true, new SimpleTabCompleterWithDelegate(new String[]{"--help", "-f", "-l"}, FilenameTabCompleter.INSTANCE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        DefaultOperationRequestBuilder builder;
        File f;
        String runtimeName;
        String name;
        ModelControllerClient client;
        block22: {
            block25: {
                block23: {
                    ModelNode result2;
                    client = ctx.getModelControllerClient();
                    if (!ctx.hasArguments()) {
                        this.printList(ctx, Util.getDeployments(client));
                        return;
                    }
                    String filePath = null;
                    name = null;
                    runtimeName = null;
                    for (String arg : ctx.getArguments()) {
                        if (filePath == null) {
                            filePath = arg;
                            continue;
                        }
                        if (name == null) {
                            name = arg;
                            continue;
                        }
                        runtimeName = arg;
                    }
                    if (filePath == null) {
                        this.printList(ctx, Util.getDeployments(client));
                        return;
                    }
                    f = new File(filePath);
                    if (!f.exists()) {
                        ctx.printLine("The path doesn't exist: " + f.getAbsolutePath());
                        return;
                    }
                    if (name == null) {
                        name = f.getName();
                    }
                    if (!Util.isDeployed(name, client)) break block22;
                    if (!ctx.hasSwitch("f")) break block23;
                    builder = new DefaultOperationRequestBuilder();
                    builder = new DefaultOperationRequestBuilder();
                    builder.setOperationName("full-replace-deployment");
                    builder.addProperty("name", name);
                    if (runtimeName != null) {
                        builder.addProperty("runtime-name", runtimeName);
                    }
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(f);
                        ModelNode request2 = builder.buildRequest();
                        OperationBuilder op = OperationBuilder.Factory.create((ModelNode)request2);
                        op.addInputStream((InputStream)is);
                        request2.get("input-stream-index").set(0);
                        result2 = client.execute(op.build());
                    }
                    catch (Exception e) {
                        try {
                            ctx.printLine("Failed to replace the deployment: " + e.getLocalizedMessage());
                        }
                        catch (Throwable throwable) {
                            StreamUtils.safeClose(is);
                            throw throwable;
                        }
                        StreamUtils.safeClose((Closeable)is);
                        return;
                    }
                    StreamUtils.safeClose((Closeable)is);
                    if (!Util.isSuccess(result2)) {
                        ctx.printLine(Util.getFailureDescription(result2));
                        return;
                    }
                    ctx.printLine("'" + name + "' re-deployed successfully.");
                    break block25;
                }
                ctx.printLine("'" + name + "' is already deployed (use -f to force re-deploy).");
            }
            return;
        }
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("deployment", name);
        if (runtimeName != null) {
            builder.addProperty("runtime-name", runtimeName);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            request = builder.buildRequest();
            OperationBuilder op = OperationBuilder.Factory.create((ModelNode)request);
            op.addInputStream((InputStream)is);
            request.get("input-stream-index").set(0);
            result = client.execute(op.build());
        }
        catch (Exception e) {
            try {
                ctx.printLine("Failed to add the deployment content to the repository: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)is);
            return;
        }
        StreamUtils.safeClose((Closeable)is);
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("deploy");
        builder.addNode("deployment", name);
        try {
            request = builder.buildRequest();
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to deploy: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("'" + name + "' deployed successfully.");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        if (!ctx.hasArguments()) {
            throw new OperationFormatException("Required arguments are missing.");
        }
        String filePath = null;
        String name = null;
        String runtimeName = null;
        for (String arg : ctx.getArguments()) {
            if (filePath == null) {
                filePath = arg;
                continue;
            }
            if (name == null) {
                name = arg;
                continue;
            }
            runtimeName = arg;
        }
        if (filePath == null) {
            throw new OperationFormatException("File path is missing.");
        }
        File f = new File(filePath);
        if (!f.exists()) {
            throw new OperationFormatException(f.getAbsolutePath() + " doesn't exist.");
        }
        if (name == null) {
            name = f.getName();
        }
        if (Util.isDeployed(name, ctx.getModelControllerClient())) {
            if (ctx.hasSwitch("f")) {
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("full-replace-deployment");
                builder.addProperty("name", name);
                if (runtimeName != null) {
                    builder.addProperty("runtime-name", runtimeName);
                }
                byte[] bytes = this.readBytes(f);
                builder.getModelNode().get("bytes").set(bytes);
                return builder.buildRequest();
            }
            throw new OperationFormatException("'" + name + "' is already deployed (use -f to force re-deploy).");
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("deployment", name);
        if (runtimeName != null) {
            builder.addProperty("runtime-name", runtimeName);
        }
        byte[] bytes = this.readBytes(f);
        builder.getModelNode().get("bytes").set(bytes);
        steps.add(builder.buildRequest());
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("deploy");
        builder.addNode("deployment", name);
        steps.add(builder.buildRequest());
        return composite;
    }

    protected byte[] readBytes(File f) throws OperationFormatException {
        byte[] bytes;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            bytes = new byte[(int)f.length()];
            int read = is.read(bytes);
            if (read != bytes.length) {
                throw new OperationFormatException("Failed to read bytes from " + f.getAbsolutePath() + ": " + read + " from " + f.length());
            }
        }
        catch (Exception e) {
            try {
                throw new OperationFormatException("Failed to read file " + f.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)is);
        return bytes;
    }
}

