/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class CreateJmsTopicHandler
extends BatchModeCommandHandler {
    public CreateJmsTopicHandler() {
        super("create-jms-topic", true, new SimpleTabCompleter(new String[]{"name=", "entries=", "--help"}));
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (OperationFormatException e1) {
            ctx.printLine(e1.getLocalizedMessage());
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("Created topic " + ctx.getNamedArgument("name"));
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        String name = ctx.getNamedArgument("name");
        if (name == null) {
            throw new OperationFormatException("Required argument 'name' is missing.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.addNode("subsystem", "jms");
        builder.addNode("topic", name);
        builder.setOperationName("add");
        ModelNode entriesNode = builder.getModelNode().get("entries");
        String entriesStr = ctx.getNamedArgument("entries");
        if (entriesStr == null) {
            entriesNode.add(name);
        } else {
            String[] split = entriesStr.split(",");
            for (int i = 0; i < split.length; ++i) {
                String entry = split[i].trim();
                if (entry.isEmpty()) continue;
                entriesNode.add(entry);
            }
        }
        return builder.buildRequest();
    }
}

