/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class DeployHandler
extends CommandHandlerWithHelp {
    public DeployHandler() {
        super("deploy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(CommandContext ctx, String args) {
        ModelNode result;
        ModelNode request;
        DefaultOperationRequestBuilder builder;
        File f;
        String runtimeName;
        String name;
        ModelControllerClient client;
        block24: {
            block27: {
                block25: {
                    ModelNode result2;
                    client = ctx.getModelControllerClient();
                    if (client == null) {
                        ctx.printLine("The controller client is not available. Make sure you are connected to the controller.");
                        return;
                    }
                    if (args == null) {
                        ctx.printColumns(Util.getDeployments(client));
                        return;
                    }
                    boolean force = false;
                    String filePath = null;
                    name = null;
                    runtimeName = null;
                    String[] arr = args.split("\\s+");
                    for (int i = 0; i < arr.length; ++i) {
                        String arg = arr[i];
                        if ("-f".equals(arg)) {
                            force = true;
                            continue;
                        }
                        if (filePath == null) {
                            filePath = arg;
                            continue;
                        }
                        if (name == null) {
                            name = arg;
                            continue;
                        }
                        runtimeName = arg;
                    }
                    if (filePath == null) {
                        ctx.printLine("File path is missing.");
                        return;
                    }
                    f = new File(filePath);
                    if (!f.exists()) {
                        ctx.printLine("The path doesn't exist: " + f.getAbsolutePath());
                        return;
                    }
                    if (name == null) {
                        name = f.getName();
                    }
                    if (!Util.isDeployed(name, ctx.getModelControllerClient())) break block24;
                    if (!force) break block25;
                    builder = new DefaultOperationRequestBuilder();
                    builder = new DefaultOperationRequestBuilder();
                    builder.setOperationName("full-replace-deployment");
                    builder.addProperty("name", name);
                    if (runtimeName != null) {
                        builder.addProperty("runtime-name", runtimeName);
                    }
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(f);
                        ModelNode request2 = builder.buildRequest();
                        OperationBuilder op = OperationBuilder.Factory.create((ModelNode)request2);
                        op.addInputStream((InputStream)is);
                        request2.get("input-stream-index").set(0);
                        result2 = client.execute(op.build());
                    }
                    catch (Exception e) {
                        try {
                            ctx.printLine("Failed to replace the deployment: " + e.getLocalizedMessage());
                        }
                        catch (Throwable throwable) {
                            StreamUtils.safeClose(is);
                            throw throwable;
                        }
                        StreamUtils.safeClose((Closeable)is);
                        return;
                    }
                    StreamUtils.safeClose((Closeable)is);
                    if (!Util.isSuccess(result2)) {
                        ctx.printLine(Util.getFailureDescription(result2));
                        return;
                    }
                    ctx.printLine("'" + name + "' re-deployed successfully.");
                    break block27;
                }
                ctx.printLine("'" + name + "' is already deployed (use -f to force re-deploy).");
            }
            return;
        }
        builder = new DefaultOperationRequestBuilder();
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("deployment", name);
        if (runtimeName != null) {
            builder.addProperty("runtime-name", runtimeName);
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            request = builder.buildRequest();
            OperationBuilder op = OperationBuilder.Factory.create((ModelNode)request);
            op.addInputStream((InputStream)is);
            request.get("input-stream-index").set(0);
            result = client.execute(op.build());
        }
        catch (Exception e) {
            try {
                ctx.printLine("Failed to add the deployment content to the repository: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)is);
            return;
        }
        StreamUtils.safeClose((Closeable)is);
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("deploy");
        builder.addNode("deployment", name);
        try {
            request = builder.buildRequest();
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to deploy: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("'" + name + "' deployed successfully.");
    }
}

