/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.handlers.SecurityActions;
import org.jboss.as.protocol.StreamUtils;

public abstract class CommandHandlerWithHelp
implements CommandHandler {
    private final String filename;

    public CommandHandlerWithHelp(String command) {
        this.filename = "help/" + command + ".txt";
    }

    @Override
    public void handle(CommandContext ctx) {
        String args = ctx.getCommandArguments();
        if (args != null) {
            if ((args = args.trim()).isEmpty()) {
                args = null;
            } else if (args.equals("--help")) {
                this.printHelp(ctx);
                return;
            }
        }
        this.handle(ctx, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printHelp(CommandContext ctx) {
        InputStream helpInput = SecurityActions.getClassLoader(CommandHandlerWithHelp.class).getResourceAsStream(this.filename);
        if (helpInput != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(helpInput));
            try {
                String helpLine = reader.readLine();
                while (helpLine != null) {
                    ctx.printLine(helpLine);
                    helpLine = reader.readLine();
                }
            }
            catch (IOException e) {
                ctx.printLine("Failed to read help/help.txt: " + e.getLocalizedMessage());
            }
            finally {
                StreamUtils.safeClose((Closeable)reader);
            }
        } else {
            ctx.printLine("Failed to locate command description " + this.filename);
        }
    }

    protected abstract void handle(CommandContext var1, String var2);
}

