/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestParser;
import org.jboss.as.cli.operation.parsing.ParsingUtil;

public class DefaultOperationRequestParser
implements OperationRequestParser {
    public static final String FORMAT = "[node-type=node-name (, node-type=node-name)*] : operation-name [ '(' name=value (, name=value)* ')' ]";
    public static final char NODE_TYPE_NAME_SEPARATOR = '=';
    public static final char NODE_SEPARATOR = '/';
    public static final char ADDRESS_OPERATION_NAME_SEPARATOR = ':';
    public static final char ARGUMENTS_LIST_START = '(';
    public static final char ARGUMENT_NAME_VALUE_SEPARATOR = '=';
    public static final char ARGUMENT_SEPARATOR = ',';
    public static final char ARGUMENTS_LIST_END = ')';
    public static final String ROOT_NODE = "/";
    public static final String PARENT_NODE = "..";
    public static final String NODE_TYPE = ".type";

    @Override
    public void parse(String operationRequest, OperationRequestParser.CallbackHandler handler) throws OperationFormatException {
        if (operationRequest == null || operationRequest.isEmpty()) {
            return;
        }
        int aoSep = operationRequest.indexOf(58);
        int addressLength = aoSep < 0 ? operationRequest.length() : (aoSep > 0 ? aoSep : 0);
        if (addressLength > 0) {
            int nodePathStart;
            if (operationRequest.startsWith("./")) {
                nodePathStart = 2;
                handler.nodeSeparator(1);
            } else {
                nodePathStart = 0;
            }
            int nodeIndex = nodePathStart;
            while (nodeIndex < addressLength) {
                int nodeSepIndex = operationRequest.indexOf(47, nodeIndex);
                String node = nodeSepIndex < 0 ? operationRequest.substring(nodeIndex, addressLength).trim() : operationRequest.substring(nodeIndex, nodeSepIndex).trim();
                if (node.isEmpty()) {
                    if (nodeSepIndex > 0) {
                        throw new OperationFormatException("Node type/name is missing or the format is wrong for the prefix '" + operationRequest.substring(0, addressLength) + "'");
                    }
                    if (nodeSepIndex == 0) {
                        handler.rootNode();
                    }
                } else {
                    int typeNameSep = node.indexOf(61);
                    if (typeNameSep < 0) {
                        if (PARENT_NODE.equals(node)) {
                            handler.parentNode();
                        } else if (NODE_TYPE.equals(node)) {
                            handler.nodeType();
                        } else if (nodeIndex == nodePathStart) {
                            if (nodeSepIndex < 0) {
                                handler.nodeTypeOrName(node);
                            } else if (aoSep > 0) {
                                handler.nodeName(node);
                            } else {
                                handler.nodeTypeOrName(node);
                            }
                        } else if (nodeSepIndex < 0) {
                            handler.nodeTypeOrName(node);
                        }
                    } else {
                        String nodeType = node.substring(0, typeNameSep).trim();
                        handler.nodeType(nodeType);
                        handler.nodeTypeNameSeparator(nodeIndex + typeNameSep);
                        String nodeName = node.substring(typeNameSep + 1).trim();
                        if (!nodeName.isEmpty()) {
                            handler.nodeName(nodeName);
                        }
                    }
                }
                if (nodeSepIndex < 0) {
                    nodeIndex = addressLength;
                    continue;
                }
                handler.nodeSeparator(nodeSepIndex);
                nodeIndex = nodeSepIndex + 1;
            }
        }
        if (aoSep < 0) {
            return;
        }
        handler.addressOperationSeparator(aoSep);
        int argListStartIndex = operationRequest.indexOf(40, aoSep + 1);
        if (argListStartIndex < 0) {
            if (aoSep + 1 < operationRequest.length()) {
                String operationName = operationRequest.substring(aoSep + 1);
                handler.operationName(operationName);
            }
            return;
        }
        String operationName = operationRequest.substring(aoSep + 1, argListStartIndex).trim();
        handler.operationName(operationName);
        ParsingUtil.parseParameters(operationRequest, argListStartIndex, handler);
    }
}

