/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.net.URI;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.protocol.servlet.ServletProtocolConfiguration;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;

public final class ServletUtil {
    public static final ArchivePath WEB_XML_PATH = ArchivePaths.create((String)"WEB-INF/web.xml");
    public static final ArchivePath APPLICATION_XML_PATH = ArchivePaths.create((String)"META-INF/application.xml");

    private ServletUtil() {
    }

    public static URI determineBaseURI(ServletProtocolConfiguration config, HTTPContext context, String servletName) {
        String scheme = config.getScheme();
        String host = config.getHost();
        Integer port = config.getPort();
        String contextRoot = null;
        Servlet servlet = context.getServletByName(servletName);
        if (servlet != null) {
            if (scheme == null) {
                scheme = "http";
            }
            if (host == null) {
                host = context.getHost();
            }
            if (port == null) {
                port = context.getPort();
            }
        } else {
            throw new IllegalArgumentException(servletName + " not found. " + "Could not determine ContextRoot from ProtocolMetadata, please contact DeployableContainer developer.");
        }
        contextRoot = servlet.getContextRoot();
        return URI.create(scheme + "://" + host + ":" + port + contextRoot);
    }

    public static String calculateContextRoot(String archiveName) {
        String correctedName = archiveName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }
}

