/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

final class Serializer {
    Serializer() {
    }

    public static byte[] toByteArray(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(out);
            outObj.writeObject(object);
            outObj.flush();
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize object: " + object, e);
        }
    }

    public static <T> T toObject(Class<T> type, byte[] objectArray) {
        try {
            ObjectInputStream outObj = new ObjectInputStream(new ByteArrayInputStream(objectArray));
            Object object = outObj.readObject();
            return type.cast(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize object: " + objectArray, e);
        }
    }

    public static <T> T toObject(Class<T> type, InputStream input) {
        try {
            ObjectInputStream outObj = new ObjectInputStream(input);
            Object object = outObj.readObject();
            T t = type.cast(object);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize object", e);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

