/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.bundle;

import aQute.bnd.osgi.Analyzer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Properties;
import java.util.UUID;
import java.util.jar.Manifest;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class BundleGeneratorHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateManifest(JavaArchive archive, Properties properties) throws Exception {
        try (Analyzer analyzer = new Analyzer();){
            File archiveFile = BundleGeneratorHelper.getFileFromArchive(archive);
            analyzer.setJar(archiveFile);
            analyzer.setProperties(properties);
            analyzer.setProperty("Bundle-Version", "1.0.0");
            analyzer.analyze();
            Manifest manifest = analyzer.calcManifest();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            ByteArrayAsset byteArrayAsset = new ByteArrayAsset(baos.toByteArray());
            archive.delete("META-INF/MANIFEST.MF");
            archive.add((Asset)byteArrayAsset, "META-INF/MANIFEST.MF");
        }
    }

    protected static File getFileFromArchive(Archive<?> archive) throws Exception {
        File archiveFile = File.createTempFile(archive.getName() + UUID.randomUUID(), ".jar");
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(archiveFile, true);
        return archiveFile;
    }
}

