/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.bundle;

import java.util.Properties;
import org.jboss.arquillian.osgi.bundle.BundleGeneratorHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ArquillianFragmentGenerator {
    public static final String TEST_BUNDLE_SYMBOLIC_NAME = "Test-Bundle-Symbolic-Name";
    public static final String TEST_BUNDLE_VERSION = "Test-Bundle-Version";

    public Archive<?> createArquillianFragment(String symbolicName, String version, TestClass testClass) throws Exception {
        JavaArchive arquillianFragmentBundleArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(symbolicName + "-fragment.jar"));
        arquillianFragmentBundleArchive.addClass(testClass.getJavaClass());
        Properties properties = new Properties();
        properties.setProperty("Bundle-SymbolicName", symbolicName + "-fragment");
        properties.setProperty("Bundle-Name", symbolicName + " Fragment");
        properties.setProperty("Bundle-Version", "1.0.0");
        properties.setProperty(TEST_BUNDLE_SYMBOLIC_NAME, symbolicName);
        properties.setProperty(TEST_BUNDLE_VERSION, "1.0.0");
        properties.setProperty("Import-Package", "*;resolution:=optional");
        properties.setProperty("Fragment-Host", "arquillian-osgi-bundle");
        BundleGeneratorHelper.generateManifest(arquillianFragmentBundleArchive, properties);
        return arquillianFragmentBundleArchive;
    }
}

