/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.client.deployment.AuxiliaryArchiveAppender;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.osgi.ArquillianBundleActivator;
import org.jboss.arquillian.osgi.bundle.BundleGeneratorHelper;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ArquillianBundleGenerator {
    private static final List<String> exportPackages = Arrays.asList("org.jboss.arquillian.container.test.api", "org.jboss.arquillian.junit", "org.jboss.arquillian.osgi", "org.jboss.arquillian.test.api", "org.jboss.shrinkwrap.api", "org.jboss.shrinkwrap.api.asset", "org.jboss.shrinkwrap.api.spec", "junit.framework", "org.hamcrest", "org.hamcrest.core", "org.junit", "org.junit.matchers", "org.junit.rules", "org.junit.runner", "org.junit.runner.manipulation", "org.junit.runner.notification", "org.junit.runners", "org.junit.runners.model", "org.junit.runners.parameterized", "org.junit.validator", "org.osgi.framework", "org.jboss.osgi.metadata");
    @Inject
    private Instance<ServiceLoader> _serviceLoaderInstance;
    private static final String _REMOTE_LOADABLE_EXTENSION_FILE = "/META-INF/services/" + RemoteLoadableExtension.class.getCanonicalName();
    public static final String BUNDLE_SYMBOLIC_NAME = "arquillian-osgi-bundle";
    public static final String BUNDLE_NAME = "Arquillian Bundle";
    public static final String BUNDLE_VERSION = "1.0.0";

    public Archive<?> createArquillianBundle() throws Exception {
        JavaArchive arquillianOSGiBundleArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-osgi-bundle.jar");
        arquillianOSGiBundleArchive.addClass(ArquillianBundleActivator.class);
        arquillianOSGiBundleArchive.addPackage(JMXTestRunner.class.getPackage());
        Properties properties = new Properties();
        properties.setProperty("Bundle-SymbolicName", BUNDLE_SYMBOLIC_NAME);
        properties.setProperty("Bundle-Name", BUNDLE_NAME);
        properties.setProperty("Bundle-Version", BUNDLE_VERSION);
        properties.setProperty("Bundle-Activator", ArquillianBundleActivator.class.getCanonicalName());
        properties.setProperty("Import-Package", "*;resolution:=optional");
        properties.setProperty("Export-Package", exportPackages.stream().collect(Collectors.joining(",")));
        List<Archive<?>> extensionArchives = this.loadAuxiliaryArchives();
        properties.setProperty("Bundle-ClassPath", this.getBundleClassPath(arquillianOSGiBundleArchive, extensionArchives));
        BundleGeneratorHelper.generateManifest(arquillianOSGiBundleArchive, properties);
        return arquillianOSGiBundleArchive;
    }

    private String getBundleClassPath(JavaArchive javaArchive, Collection<Archive<?>> auxiliaryArchives) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(".");
        for (Archive<?> auxiliaryArchive : auxiliaryArchives) {
            Map remoteLoadableExtensionMap = auxiliaryArchive.getContent(Filters.include((String)_REMOTE_LOADABLE_EXTENSION_FILE));
            Collection remoteLoadableExtensions = remoteLoadableExtensionMap.values();
            if (remoteLoadableExtensions.size() > 1) {
                throw new RuntimeException("The archive " + auxiliaryArchive.getName() + " contains more than one RemoteLoadableExtension file");
            }
            if (remoteLoadableExtensions.size() == 1) {
                Iterator remoteLoadableExtensionsIterator = remoteLoadableExtensions.iterator();
                Node remoteLoadableExtensionsNext = (Node)remoteLoadableExtensionsIterator.next();
                javaArchive.add(remoteLoadableExtensionsNext.getAsset(), _REMOTE_LOADABLE_EXTENSION_FILE);
            }
            InputStream auxiliaryArchiveInputStream = ((ZipExporter)auxiliaryArchive.as(ZipExporter.class)).exportAsInputStream();
            ByteArrayAsset byteArrayAsset = new ByteArrayAsset(auxiliaryArchiveInputStream);
            String path = "extension/" + auxiliaryArchive.getName();
            javaArchive.addAsResource((Asset)byteArrayAsset, path);
            sb.append(",");
            sb.append(path);
        }
        return sb.toString();
    }

    private List<Archive<?>> loadAuxiliaryArchives() {
        ArrayList archives = new ArrayList();
        ServiceLoader serviceLoader = (ServiceLoader)this._serviceLoaderInstance.get();
        Collection archiveAppenders = serviceLoader.all(AuxiliaryArchiveAppender.class);
        for (AuxiliaryArchiveAppender archiveAppender : archiveAppenders) {
            Archive auxiliaryArchive = archiveAppender.createAuxiliaryArchive();
            if (auxiliaryArchive == null) continue;
            archives.add(auxiliaryArchive);
        }
        return archives;
    }
}

