/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class ArquillianBundleActivator
implements BundleActivator {
    private static Logger log = Logger.getLogger(ArquillianBundleActivator.class.getName());
    private JMXTestRunner testRunner;
    private long arqBundleId;

    public void start(BundleContext context) throws Exception {
        this.arqBundleId = context.getBundle().getBundleId();
        final BundleContext syscontext = context.getBundle(0L).getBundleContext();
        final JMXTestRunner.TestClassLoader testClassLoader = className -> {
            String namePath = className.replace('.', '/') + ".class";
            Supplier<Stream> bundlesSuplier = () -> Arrays.asList(syscontext.getBundles()).stream().filter(bundle -> bundle.getBundleId() > this.arqBundleId && bundle.getState() != 1);
            Optional<Bundle> testBundleOptional = bundlesSuplier.get().filter(bundle -> bundle.getEntry(namePath) != null).findAny().isPresent() ? bundlesSuplier.get().filter(bundle -> bundle.getEntry(namePath) != null).findAny() : bundlesSuplier.get().filter(bundle -> bundle.getHeaders().get("Bundle-ClassPath") != null).filter(bundle -> {
                try {
                    bundle.loadClass(className);
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }).findAny();
            return testBundleOptional.orElseThrow(() -> new ClassNotFoundException("Test '" + className + "' not found in: " + ((Stream)bundlesSuplier.get()).collect(Collectors.toList()))).loadClass(className);
        };
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner = new JMXTestRunner(testClassLoader){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] runTestMethod(String className, String methodName) {
                Thread thread = Thread.currentThread();
                ClassLoader contextClassLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(testClassLoader.loadTestClass(className).getClassLoader());
                    byte[] byArray = super.runTestMethod(className, methodName);
                    return byArray;
                }
                catch (ClassNotFoundException e) {
                    log.warning("Can't find class" + className);
                }
                finally {
                    thread.setContextClassLoader(contextClassLoader);
                }
                return null;
            }

            public byte[] runTestMethod(String className, String methodName, Map<String, String> protocolProps) {
                Class testClass;
                try {
                    testClass = testClassLoader.loadTestClass(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
                BundleAssociation.setBundle((Bundle)ArquillianBundleActivator.this.getTestBundle(syscontext, testClass, methodName));
                BundleContextAssociation.setBundleContext((BundleContext)syscontext);
                return super.runTestMethod(className, methodName, protocolProps);
            }
        };
        this.testRunner.registerMBean(mbeanServer);
    }

    public void stop(BundleContext context) throws Exception {
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner.unregisterMBean(mbeanServer);
    }

    private MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warning("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.fine("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            log.fine("No MBeanServer, create one ...");
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mbeanServer;
    }

    private Bundle getTestBundle(BundleContext syscontext, Class<?> testClass, String methodName) {
        Bundle bundle = ((BundleReference)testClass.getClassLoader()).getBundle();
        block0: for (Method method : testClass.getMethods()) {
            OperateOnDeployment opon = method.getAnnotation(OperateOnDeployment.class);
            if (opon == null || !methodName.equals(method.getName())) continue;
            for (Bundle aux : syscontext.getBundles()) {
                if (!aux.getLocation().equals(opon.value())) continue;
                bundle = aux;
                continue block0;
            }
        }
        return bundle;
    }
}

