/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.osgi;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextAssociation;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;

public class ArquillianBundleActivator
implements BundleActivator {
    private static Logger log = Logger.getLogger(ArquillianBundleActivator.class.getName());
    private JMXTestRunner testRunner;

    public void start(final BundleContext context) throws Exception {
        final BundleContext syscontext = context.getBundle(0L).getBundleContext();
        final JMXTestRunner.TestClassLoader testClassLoader = new JMXTestRunner.TestClassLoader(){

            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                return context.getBundle().loadClass(className);
            }
        };
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner = new JMXTestRunner(testClassLoader){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] runTestMethod(String className, String methodName) {
                Thread thread = Thread.currentThread();
                ClassLoader contextClassLoader = thread.getContextClassLoader();
                try {
                    Bundle bundle = context.getBundle();
                    thread.setContextClassLoader(((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader());
                    byte[] byArray = super.runTestMethod(className, methodName);
                    return byArray;
                }
                finally {
                    thread.setContextClassLoader(contextClassLoader);
                }
            }

            public byte[] runTestMethod(String className, String methodName, Map<String, String> protocolProps) {
                Class testClass;
                try {
                    testClass = testClassLoader.loadTestClass(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
                Bundle fragmentBundle = ArquillianBundleActivator.this.getFragmentBundle(context);
                Bundle testBundle = ArquillianBundleActivator.this.getTestBundle(syscontext, (String)fragmentBundle.getHeaders().get("Test-Bundle-Symbolic-Name"), testClass, methodName);
                FrameworkWiring adapt = (FrameworkWiring)syscontext.getBundle().adapt(FrameworkWiring.class);
                adapt.resolveBundles(Arrays.asList(testBundle));
                BundleAssociation.setBundle((Bundle)testBundle);
                BundleContextAssociation.setBundleContext((BundleContext)syscontext);
                return super.runTestMethod(className, methodName, protocolProps);
            }
        };
        this.testRunner.registerMBean(mbeanServer);
    }

    public void stop(BundleContext context) throws Exception {
        MBeanServer mbeanServer = this.findOrCreateMBeanServer();
        this.testRunner.unregisterMBean(mbeanServer);
    }

    private MBeanServer findOrCreateMBeanServer() {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> serverArr = MBeanServerFactory.findMBeanServer(null);
        if (serverArr.size() > 1) {
            log.warning("Multiple MBeanServer instances: " + serverArr);
        }
        if (serverArr.size() > 0) {
            mbeanServer = serverArr.get(0);
            log.fine("Found MBeanServer: " + mbeanServer.getDefaultDomain());
        }
        if (mbeanServer == null) {
            log.fine("No MBeanServer, create one ...");
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mbeanServer;
    }

    private Bundle getFragmentBundle(BundleContext context) {
        BundleWiring bundleWiring = (BundleWiring)context.getBundle().adapt(BundleWiring.class);
        ArrayList<Bundle> fragmentBundles = new ArrayList<Bundle>();
        if (bundleWiring != null) {
            List providedWires = bundleWiring.getProvidedWires("osgi.wiring.host");
            for (BundleWire providedWire : providedWires) {
                fragmentBundles.add(providedWire.getRequirerWiring().getRevision().getBundle());
            }
        }
        if (fragmentBundles.isEmpty()) {
            throw new RuntimeException("There are not fragment associated with the context");
        }
        if (fragmentBundles.size() > 1) {
            throw new RuntimeException("There are more than one fragment for the Arquilian Bundle");
        }
        return (Bundle)fragmentBundles.get(0);
    }

    private Bundle getTestBundle(BundleContext syscontext, String testBundleSymbolicName, Class<?> testClass, String methodName) {
        Bundle testBundle = null;
        for (Bundle bundle : syscontext.getBundles()) {
            if (!bundle.getSymbolicName().equals(testBundleSymbolicName)) continue;
            testBundle = bundle;
            break;
        }
        block1: for (Method method : testClass.getMethods()) {
            OperateOnDeployment opon = method.getAnnotation(OperateOnDeployment.class);
            if (opon == null || !methodName.equals(method.getName())) continue;
            for (Bundle aux : syscontext.getBundles()) {
                if (!aux.getLocation().equals(opon.value())) continue;
                testBundle = aux;
                continue block1;
            }
        }
        return testBundle;
    }
}

