/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location.decider;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.graphene.location.exception.LocationException;
import org.jboss.arquillian.graphene.spi.location.LocationDecider;
import org.jboss.arquillian.graphene.spi.location.Scheme;

public class FileLocationDecider
implements LocationDecider {
    private final Scheme scheme = new Scheme.FILE();

    public Scheme canDecide() {
        return this.scheme;
    }

    public String decide(String location) {
        Validate.notNull((Object)location, (String)"Location to decide can not be a null object.");
        if (!location.startsWith(this.scheme.toString())) {
            location = this.scheme.toString() + location;
        }
        try {
            URI uri = new URI(location);
            File file = new File(uri);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.format("File specified by %s was not found", location));
            }
            return this.fileToUrl(file).toExternalForm();
        }
        catch (URISyntaxException ex) {
            throw new LocationException(String.format("Unable to convert '%s' to URI", location), ex.getCause());
        }
    }

    private URL fileToUrl(File file) {
        Validate.notNull((Object)file, (String)"File to get URL of can not be a null object.");
        try {
            URL url = file.getAbsoluteFile().toURI().toURL();
            return url;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(String.format("Unable to get URL of file %s", file.getAbsolutePath()), ex.getCause());
        }
    }
}

