/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyHandler;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public abstract class SeleniumResourceProvider
implements ResourceProvider {
    protected abstract String getReturnType();

    public boolean canProvide(Class<?> type) {
        return type.getName().equals(this.getReturnType());
    }

    protected final Class<?> getTypeArgument(int i) {
        ParameterizedType superType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] typeArguments = superType.getActualTypeArguments();
        return (Class)typeArguments[i];
    }

    public static void registerAllProviders(LoadableExtension.ExtensionBuilder builder) {
        for (Class<?> clazz : SeleniumResourceProvider.class.getClasses()) {
            if (!SeleniumResourceProvider.class.isAssignableFrom(clazz)) continue;
            builder.service(ResourceProvider.class, clazz);
        }
    }

    private static abstract class IndirectProvider<M>
    extends SeleniumResourceProvider {
        protected Class<?> mediatorType = this.getTypeArgument(0);

        IndirectProvider() {
        }

        protected <BASE> BASE base(final Annotation[] annotations) {
            final GrapheneProxy.FutureTarget futureTarget = new GrapheneProxy.FutureTarget(){

                @Override
                public Object getTarget() {
                    GrapheneContext context = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(annotations));
                    return context.getWebDriver(new Class[]{mediatorType});
                }
            };
            GrapheneProxyHandler mediatorHandler = new GrapheneProxyHandler(futureTarget){

                @Override
                public Object invoke(Object proxy, final Method mediatorMethod, final Object[] mediatorArgs) throws Throwable {
                    GrapheneProxyHandler handler = new GrapheneProxyHandler(futureTarget){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object mediatorObject = mediatorMethod.invoke(this.getTarget(), mediatorArgs);
                            return method.invoke(mediatorObject, args);
                        }
                    };
                    return GrapheneProxy.getProxyForHandler(handler, mediatorMethod.getReturnType(), new Class[0]);
                }
            };
            return (BASE)GrapheneProxy.getProxyForHandler(mediatorHandler, WebDriver.class, this.mediatorType);
        }

        public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
            Object base = this.base(qualifiers);
            return this.generateProxy(base);
        }

        public abstract Object generateProxy(M var1);
    }

    private static abstract class DirectProvider
    extends SeleniumResourceProvider {
        private DirectProvider() {
        }

        public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
            GrapheneContext context = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(qualifiers));
            try {
                return context.getWebDriver(new Class[]{Class.forName(this.getReturnType())});
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("The class of the provider is not on the class path.", ex);
            }
        }
    }

    public static class ActionsProvider
    extends IndirectProvider<HasInputDevices> {
        @Override
        public Object generateProxy(HasInputDevices base) {
            return new Actions((WebDriver)base);
        }

        @Override
        protected String getReturnType() {
            return Actions.class.getName();
        }
    }

    public static class TouchScreenProvider
    extends IndirectProvider<HasTouchScreen> {
        @Override
        public Object generateProxy(HasTouchScreen base) {
            return base.getTouch();
        }

        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.interactions.TouchScreen";
        }
    }

    public static class CapabilitiesProvider
    extends IndirectProvider<HasCapabilities> {
        @Override
        public Object generateProxy(HasCapabilities base) {
            return base.getCapabilities();
        }

        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.Capabilities";
        }
    }

    public static class MouseProvider
    extends IndirectProvider<HasInputDevices> {
        @Override
        public Object generateProxy(HasInputDevices base) {
            return base.getMouse();
        }

        @Override
        protected String getReturnType() {
            return Mouse.class.getName();
        }
    }

    public static class KeyboardProvider
    extends IndirectProvider<HasInputDevices> {
        @Override
        public Object generateProxy(HasInputDevices base) {
            return base.getKeyboard();
        }

        @Override
        protected String getReturnType() {
            return Keyboard.class.getName();
        }
    }

    public static class SessionStorageProvider
    extends IndirectProvider<WebStorage> {
        @Override
        public Object generateProxy(WebStorage base) {
            return base.getSessionStorage();
        }

        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.html5.SessionStorage";
        }
    }

    public static class LocalStorageProvider
    extends IndirectProvider<WebStorage> {
        @Override
        public Object generateProxy(WebStorage base) {
            return base.getLocalStorage();
        }

        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.html5.LocalStorage";
        }
    }

    public static class DatabaseStorageProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.html5.DatabaseStorage";
        }
    }

    public static class WebStorageProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.html5.WebStorage";
        }
    }

    public static class BrowserConnectionProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.html5.BrowserConnection";
        }
    }

    public static class ApplicationCacheProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.html5.ApplicationCache";
        }
    }

    public static class LocationContextProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.html5.LocationContext";
        }
    }

    public static class RotatableProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.Rotatable";
        }
    }

    public static class TakesScreenshotProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return "org.openqa.selenium.TakesScreenshot";
        }
    }

    public static class JavascriptExecutorProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return JavascriptExecutor.class.getName();
        }
    }

    public static class WebDriverProvider
    extends DirectProvider {
        @Override
        protected String getReturnType() {
            return WebDriver.class.getName();
        }
    }
}

