/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodProxy;

public abstract class GrapheneProxyHandler
implements MethodInterceptor,
InvocationHandler {
    private Object target;
    private GrapheneProxy.FutureTarget future;

    public GrapheneProxyHandler(Object target) {
        this.target = target;
    }

    public GrapheneProxyHandler(GrapheneProxy.FutureTarget future) {
        this.future = future;
    }

    @Override
    public abstract Object invoke(Object var1, Method var2, Object[] var3) throws Throwable;

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invoke(obj, method, args);
    }

    protected boolean isProxyable(Method method, Object[] args) {
        Class<?> returnType = method.getReturnType();
        return returnType.isInterface();
    }

    protected Object invokeReal(Object target, Method method, Object[] args) throws Throwable {
        Object result;
        try {
            if (target instanceof GrapheneProxyInstance) {
                target = ((GrapheneProxyInstance)target).unwrap();
            }
            if (!method.getDeclaringClass().isInstance(target)) {
                Method realMethod = target.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (!realMethod.isAccessible()) {
                    realMethod.setAccessible(true);
                }
                result = realMethod.invoke(target, args);
            } else {
                result = method.invoke(target, args);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception during invocation of " + method.getDeclaringClass().getName() + "#" + method.getName() + "(), on target '" + target + "': " + e.getMessage(), e);
        }
        return result;
    }

    protected Object getTarget() {
        return this.future == null ? this.target : this.future.getTarget();
    }
}

