/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.cglib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.core.DefaultNamingPolicy;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.core.NamingPolicy;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.core.Predicate;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Callback;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.CallbackFilter;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Enhancer;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.Factory;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodInterceptor;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.NoOp;
import org.jboss.arquillian.graphene.shaded.org.objenesis.Objenesis;
import org.jboss.arquillian.graphene.shaded.org.objenesis.ObjenesisStd;

public class ClassImposterizer {
    private static final String TAG = "ByGraphene";
    private final Objenesis objenesis = new ObjenesisStd();
    private static final NamingPolicy DEFAULT_POLICY = new DefaultNamingPolicy(){

        @Override
        protected String getTag() {
            return ClassImposterizer.TAG;
        }
    };
    private static final NamingPolicy SIGNED_CLASSES_POLICY = new DefaultNamingPolicy(){

        @Override
        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }

        @Override
        protected String getTag() {
            return ClassImposterizer.TAG;
        }
    };
    private static final CallbackFilter IGNORED_METHODS = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            return this.isIgnoredMethod(method) ? 1 : 0;
        }

        public boolean isIgnoredMethod(Method method) {
            return method.isBridge() || this.isGroovyMethod(method);
        }

        private boolean isGroovyMethod(Method method) {
            String[] groovyIgnores = new String[]{"$", "this$", "super$", "getMetaClass"};
            HashSet<String> groovyPrefixes = new HashSet<String>(Arrays.asList(groovyIgnores));
            for (String prefix : groovyPrefixes) {
                if (!method.getName().startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    };

    protected ClassImposterizer() {
    }

    protected <T> T imposteriseProtected(MethodInterceptor interceptor, Class<?> mockedType, Class<?> ... ancillaryTypes) {
        if (mockedType.isInterface()) {
            return this.imposteriseInterface(interceptor, mockedType, ancillaryTypes);
        }
        return this.imposteriseClass(interceptor, mockedType, ancillaryTypes);
    }

    protected <T> T imposteriseClass(MethodInterceptor interceptor, Class<?> mockedType, Class<?> ... ancillaryTypes) {
        this.setConstructorsAccessible(mockedType, true);
        Class<?> proxyClass = this.createProxyClass(mockedType, ancillaryTypes);
        return (T)mockedType.cast(this.createProxy(proxyClass, interceptor));
    }

    protected <T> T imposteriseInterface(MethodInterceptor interceptor, Class<?> mockedInterface, Class<?> ... ancillaryTypes) {
        if (!Modifier.isPublic(mockedInterface.getModifiers())) {
            throw new IllegalArgumentException("Imposterized interface must be public: " + mockedInterface);
        }
        ArrayList list = new ArrayList(Arrays.asList(ancillaryTypes));
        list.add(mockedInterface);
        Class[] interfaces = list.toArray(new Class[list.size()]);
        return this.imposteriseClass(interceptor, Object.class, interfaces);
    }

    private void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    private Class<?> createProxyClass(Class<?> mockedType, Class<?> ... interfaces) {
        if (mockedType == Object.class) {
            mockedType = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        ClassEnhancer enhancer = new ClassEnhancer();
        enhancer.setUseFactory(true);
        enhancer.setSuperclass(mockedType);
        enhancer.setInterfaces(interfaces);
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORED_METHODS);
        enhancer.setNamingPolicy(mockedType.getSigners() != null ? SIGNED_CLASSES_POLICY : DEFAULT_POLICY);
        return enhancer.createClass();
    }

    private Object createProxy(Class<?> proxyClass, Callback callback) {
        Factory proxy = (Factory)this.objenesis.newInstance(proxyClass);
        proxy.setCallbacks(new Callback[]{callback, NoOp.INSTANCE});
        return proxy;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }

    private static class ClassEnhancer
    extends Enhancer {
        private ClassEnhancer() {
        }

        @Override
        protected void filterConstructors(Class sc, List constructors) {
        }
    }
}

