/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.PageObjectEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.location.ContextRootStore;
import org.jboss.arquillian.graphene.page.InitialPage;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationEnricher
implements TestEnricher {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<ContextRootStore> locationStore;

    public void enrich(Object testCase) {
    }

    public Object[] resolve(Method method) {
        int indexOfInitialPage = this.getIndexOfParameterWithAnnotation(InitialPage.class, method);
        if (indexOfInitialPage == -1) {
            return new Object[method.getParameterTypes().length];
        }
        Class<?> qualifier = ReflectionHelper.getQualifier(method.getParameterAnnotations()[indexOfInitialPage]);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] result = new Object[method.getParameterTypes().length];
        result[indexOfInitialPage] = this.goTo(parameterTypes[indexOfInitialPage], qualifier);
        return result;
    }

    public <T> T goTo(Class<T> pageObject, Class<?> browserQualifier) {
        T result = null;
        GrapheneContext grapheneContext = GrapheneContext.getContextFor(browserQualifier);
        WebDriver browser = grapheneContext.getWebDriver(new Class[0]);
        try {
            result = (T)PageObjectEnricher.setupPage(grapheneContext, (SearchContext)browser, pageObject);
        }
        catch (Exception e) {
            throw new GrapheneTestEnricherException("Error while initializing: " + pageObject, e);
        }
        this.handleLocationOf(pageObject, browser);
        return result;
    }

    private void handleLocationOf(Class<?> pageObjectClass, WebDriver browser) {
        Location location = pageObjectClass.getAnnotation(Location.class);
        if (location == null) {
            throw new IllegalArgumentException(String.format("The page object '%s' that you are navigating to using either Graphene.goTo(<page_object>) or @InitialPage isn't annotated with @Location", pageObjectClass.getSimpleName()));
        }
        try {
            URL url = this.getURLFromLocation(location);
            browser.get(url.toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("Location '%s' specified on %s is not valid URL", location.value(), pageObjectClass.getSimpleName()));
        }
    }

    private URL getURLFromLocationWithRoot(Location location) throws MalformedURLException {
        URL contextRoot = ((ContextRootStore)this.locationStore.get()).getURL();
        if (contextRoot != null) {
            return new URL(contextRoot, location.value());
        }
        throw new IllegalStateException(String.format("The location %s is not valid URI and no contextRoot was discovered to treat it as relative URL", location));
    }

    private URL getURLFromLocation(Location location) throws MalformedURLException {
        URI uri;
        try {
            uri = new URI(location.value());
            if (!uri.isAbsolute()) {
                return this.getURLFromLocationWithRoot(location);
            }
        }
        catch (URISyntaxException e) {
            return this.getURLFromLocationWithRoot(location);
        }
        if ("resource".equals(uri.getScheme())) {
            URL url;
            String resourceName = uri.getSchemeSpecificPart();
            if (resourceName.startsWith("//")) {
                resourceName = resourceName.substring(2);
            }
            if ((url = LocationEnricher.class.getClassLoader().getResource(resourceName)) == null) {
                throw new IllegalArgumentException(String.format("Resource '%s' specified by %s was not found", resourceName, location));
            }
            return url;
        }
        if ("file".equals(uri.getScheme())) {
            File file = new File(uri);
            if (file.exists()) {
                throw new IllegalArgumentException(String.format("File specified by %s was not found", location));
            }
            return file.getAbsoluteFile().toURI().toURL();
        }
        return uri.toURL();
    }

    private int getIndexOfParameterWithAnnotation(Class<? extends Annotation> annotation, Method method) {
        int result;
        Annotation[][] annotationsOfAllParameters = method.getParameterAnnotations();
        boolean founded = false;
        for (result = 0; result < annotationsOfAllParameters.length; ++result) {
            for (int j = 0; j < annotationsOfAllParameters[result].length; ++j) {
                if (!annotationsOfAllParameters[result][j].annotationType().equals(annotation)) continue;
                founded = true;
                break;
            }
            if (founded) break;
        }
        if (!founded) {
            return -1;
        }
        return result;
    }
}

