/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.selenium.server.impl;

import java.io.File;
import java.io.IOException;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.selenium.server.configuration.SeleniumServerConfiguration;
import org.jboss.arquillian.drone.selenium.server.event.SeleniumServerConfigured;
import org.jboss.arquillian.drone.selenium.server.event.SeleniumServerStarted;
import org.jboss.arquillian.drone.selenium.server.impl.SecurityActions;
import org.jboss.arquillian.drone.selenium.server.impl.SystemEnvHolder;
import org.jboss.arquillian.drone.selenium.server.impl.Validate;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;

public class SeleniumServerCreator {
    @Inject
    private Instance<SeleniumServerConfiguration> seleniumServerConfiguration;
    @Inject
    private Event<SeleniumServerStarted> afterStart;
    @Inject
    @SuiteScoped
    private InstanceProducer<SeleniumServer> seleniumServer;

    public void seleniumServerStartUp(@Observes SeleniumServerConfigured event) throws IOException {
        SeleniumServerConfiguration configuration = (SeleniumServerConfiguration)this.seleniumServerConfiguration.get();
        if (configuration == null || configuration.isSkip()) {
            return;
        }
        try {
            SeleniumServer server = new SeleniumServer(this.configure(configuration));
            SystemEnvHolder sysEnv = new SystemEnvHolder();
            sysEnv.modifyEnvBy(configuration);
            server.boot();
            sysEnv.restore();
            this.seleniumServer.set((Object)server);
            this.afterStart.fire((Object)new SeleniumServerStarted());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start Selenium Server", e);
        }
    }

    private RemoteControlConfiguration configure(SeleniumServerConfiguration configuration) {
        String forcedMode;
        RemoteControlConfiguration rcc = new RemoteControlConfiguration();
        rcc.setAvoidProxy(configuration.isAvoidProxy());
        rcc.setBrowserSideLogEnabled(configuration.isBrowserSideLog());
        rcc.setDebugMode(configuration.isDebug());
        rcc.setDontTouchLogging(configuration.isDontTouchLogging());
        SecurityActions.setProperty("selenium.loglevel", configuration.isDebug() ? "DEBUG" : "INFO");
        rcc.setEnsureCleanSession(configuration.isEnsureCleanSession());
        String ffProfile = configuration.getFirefoxProfileTemplate();
        if (Validate.isNotNullOrEmpty(ffProfile)) {
            Validate.isValidFile(ffProfile, "Firefox profile must point to a readable directory: " + ffProfile);
            rcc.setFirefoxProfileTemplate(new File(ffProfile));
        }
        if (Validate.isNotNullOrEmpty(forcedMode = configuration.getForcedBrowserMode())) {
            rcc.setForcedBrowserMode(forcedMode);
        }
        rcc.setHonorSystemProxy(configuration.isHonorSystemProxy());
        String logFile = configuration.getLogFile();
        if (Validate.isNotNullOrEmpty(logFile)) {
            Validate.isInReadableDirectory(logFile, "Log file cannot be created: " + logFile);
            rcc.setLogOutFile(new File(logFile));
        }
        rcc.setPort(configuration.getPort());
        String profiles = configuration.getProfilesLocation();
        if (Validate.isNotNullOrEmpty(profiles)) {
            Validate.isValidFile(profiles, "Profiles location must point to a readable directory: " + profiles);
            rcc.setProfilesLocation(new File(profiles));
        }
        rcc.setProxyInjectionModeArg(configuration.isProxyInjectionMode());
        rcc.setReuseBrowserSessions(configuration.isBrowserSessionReuse());
        rcc.setRetryTimeoutInSeconds(configuration.getRetryTimeoutInSeconds());
        rcc.setSingleWindow(configuration.isSingleWindow());
        rcc.setTimeoutInSeconds(configuration.getTimeoutInSeconds());
        rcc.setTrustAllSSLCertificates(configuration.isTrustAllSSLCertificates());
        String userExtensions = configuration.getUserExtensions();
        if (Validate.isNotNullOrEmpty(userExtensions)) {
            Validate.isValidFile(userExtensions, "User extensions must point to a valid file");
            rcc.setUserExtensions(new File(userExtensions));
        }
        return rcc;
    }
}

