/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.impl.DeploymentDronePointsRegistry;
import org.jboss.arquillian.drone.impl.InjectionPoints;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.command.PrepareDrone;
import org.jboss.arquillian.test.spi.TestEnricher;

public class DroneTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(DroneTestEnricher.class.getName());
    @Inject
    private Instance<Injector> injector;
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Event<PrepareDrone> prepareDroneCommand;
    @Inject
    @ApplicationScoped
    private InstanceProducer<DeploymentDronePointsRegistry> deploymentDronePointsRegistry;

    public void enrich(Object testCase) {
        this.enrichTestClass(testCase.getClass(), testCase, false);
    }

    public Object[] resolve(Method method) {
        DroneContext context = (DroneContext)this.droneContext.get();
        DronePoint<?>[] dronePoints = InjectionPoints.parametersInMethod((DroneContext)this.droneContext.get(), method);
        Object[] resolution = new Object[dronePoints.length];
        for (int i = 0; i < dronePoints.length; ++i) {
            DronePoint<?> dronePoint = dronePoints[i];
            if (dronePoint == null) {
                resolution[i] = null;
                continue;
            }
            if (!this.ensureInjectionPointPrepared(dronePoint, true)) {
                this.registerDeploymentDronePoint(dronePoint, method);
                continue;
            }
            log.log(Level.FINE, "Injecting @Drone for method {0}, injection point {1}", new Object[]{method.getName(), dronePoint});
            Object drone = context.get(dronePoint).getInstance();
            Validate.stateNotNull(drone, "Retrieved a null from Drone Context, which is not a valid Drone browser object.\nMethod: {0}, injection point: {1},", method.getName(), dronePoint);
            resolution[i] = drone;
        }
        return resolution;
    }

    public void enrichTestClass(Class<?> testClass, Object testCase, boolean onlyStatic) {
        DroneContext context = (DroneContext)this.droneContext.get();
        Map<Field, DronePoint<?>> injectionPoints = InjectionPoints.fieldsInClass((DroneContext)this.droneContext.get(), testClass);
        for (Field field : injectionPoints.keySet()) {
            if (onlyStatic && !Modifier.isStatic(field.getModifiers())) continue;
            if (SecurityActions.getFieldValue(testCase, field) != null) {
                log.log(Level.FINER, "Skipped injection of field {0}", field.getName());
                continue;
            }
            DronePoint<?> dronePoint = injectionPoints.get(field);
            if (!this.ensureInjectionPointPrepared(dronePoint, false)) {
                this.registerDeploymentDronePoint(dronePoint, testCase);
                continue;
            }
            log.log(Level.FINE, "Injecting @Drone for field {0}, injection point {1}", new Object[]{dronePoint.getDroneType().getSimpleName(), dronePoint});
            Object drone = context.get(dronePoint).getInstance();
            Validate.stateNotNull(drone, "Retrieved a null from Drone Context, which is not a valid Drone browser object. \nClass: {0}, field: {1}, injection point: {2}", testClass.getName(), field.getName(), dronePoint);
            SecurityActions.setFieldValue(testCase, field, drone);
        }
    }

    private void registerDeploymentDronePoint(DronePoint dronePoint, Object testCase) {
        if (this.deploymentDronePointsRegistry.get() == null) {
            this.deploymentDronePointsRegistry.set(((Injector)this.injector.get()).inject((Object)new DeploymentDronePointsRegistry()));
        }
        ((DeploymentDronePointsRegistry)this.deploymentDronePointsRegistry.get()).addDronePoint(dronePoint, testCase);
    }

    private boolean ensureInjectionPointPrepared(DronePoint<?> dronePoint, boolean forMethod) {
        if (!((DroneContext)this.droneContext.get()).get(dronePoint).hasFutureInstance()) {
            if (dronePoint.getLifecycle() != DronePoint.Lifecycle.DEPLOYMENT) {
                if (dronePoint.getLifecycle() == DronePoint.Lifecycle.CLASS) {
                    log.log(Level.WARNING, "Injection point {0} was not prepared yet. It will be prepared now, but it''s recommended that all drones with class lifecycle are prepared in @BeforeClass by the DroneLifecycleManager!", dronePoint);
                }
                this.prepareDroneCommand.fire((Object)new PrepareDrone(dronePoint));
            } else {
                if (forMethod) {
                    throw new IllegalStateException(MessageFormat.format("Injection point {0} was not prepared yet. It has deployment lifecycle and is used as a method parameter. In this case the injection point has to be prepared before the method starts. Please make sure that the deployment was already deployed before the method starts. In case of the manual deployment inside of the test method, use the injection point as an instance variable.", dronePoint));
                }
                return false;
            }
        }
        return true;
    }
}

