/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.threading.ExecutorService;
import org.jboss.arquillian.drone.impl.DroneLifecycleManager;
import org.jboss.arquillian.drone.impl.DroneTimeoutException;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.CachingCallable;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointContext;
import org.jboss.arquillian.drone.spi.event.AfterDroneInstantiated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneInstantiated;

public class DronePointContextImpl<DRONE>
implements DronePointContext<DRONE> {
    private static final Logger LOGGER = Logger.getLogger(DronePointContextImpl.class.getName());
    private final DronePoint<DRONE> dronePoint;
    private final Map<Class<? extends DronePointContext.MetadataKey<?>>, Object> metadataMap;
    private CachingCallable<DRONE> futureInstance;
    private DroneConfiguration<?> configuration;
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Instance<ExecutorService> executorService;
    @Inject
    private Event<BeforeDroneInstantiated> beforeDroneInstantiatedEvent;
    @Inject
    private Event<AfterDroneInstantiated> afterDroneInstantiatedEvent;

    public DronePointContextImpl(DronePoint<DRONE> dronePoint) {
        this.dronePoint = dronePoint;
        this.metadataMap = new HashMap();
    }

    public DronePoint<DRONE> getDronePoint() {
        return this.dronePoint;
    }

    public DRONE getInstance() throws IllegalStateException {
        boolean newInstance;
        CachingCallable<DRONE> futureInstance = this.futureInstance;
        if (futureInstance == null) {
            throw new IllegalStateException(MessageFormat.format("Future instance callable is not stored for drone point {0}!", this.dronePoint));
        }
        boolean bl = newInstance = !futureInstance.isValueCached();
        if (newInstance) {
            this.beforeDroneInstantiatedEvent.fire((Object)new BeforeDroneInstantiated(this.dronePoint));
        }
        DRONE drone = this.instantiateDrone(futureInstance);
        if (newInstance) {
            this.afterDroneInstantiatedEvent.fire((Object)new AfterDroneInstantiated(this.dronePoint));
        }
        if (futureInstance != this.futureInstance) {
            return this.getInstance();
        }
        return drone;
    }

    public <CAST_DRONE> CAST_DRONE getInstanceAs(Class<CAST_DRONE> droneClass) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull(droneClass, "Given drone class cannot be null!", new Object[0]);
        if (!this.dronePoint.conformsTo(droneClass)) {
            throw new IllegalStateException(MessageFormat.format("Could not cast instance from {0} to {1}!", this.dronePoint.getDroneType().getName(), droneClass.getName()));
        }
        return droneClass.cast(this.getInstance());
    }

    public <CONF extends DroneConfiguration<CONF>> CONF getConfigurationAs(Class<CONF> configurationClass) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull(configurationClass, "Given configuration class cannot be null!", new Object[0]);
        if (this.configuration == null) {
            throw new IllegalStateException(MessageFormat.format("Configuration is not set for drone point {0}!", this.dronePoint));
        }
        if (!configurationClass.isAssignableFrom(this.configuration.getClass())) {
            throw new IllegalStateException(MessageFormat.format("Could not cast configuration from {0} to {1}!", this.configuration.getClass().getName(), configurationClass.getName()));
        }
        return (CONF)((DroneConfiguration)configurationClass.cast(this.configuration));
    }

    public <KEY extends DronePointContext.MetadataKey<VALUE>, VALUE> VALUE getMetadata(Class<KEY> keyClass) throws IllegalArgumentException {
        Validate.notNull(keyClass, "Given key class canoot be null!", new Object[0]);
        return (VALUE)this.metadataMap.get(keyClass);
    }

    public boolean isInstantiated() {
        return this.hasFutureInstance() && this.futureInstance.isValueCached();
    }

    public boolean hasFutureInstance() {
        return this.futureInstance != null;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public <KEY extends DronePointContext.MetadataKey<VALUE>, VALUE> boolean hasMetadata(Class<KEY> keyClass) {
        Validate.notNull(keyClass, "Given key class canoot be null!", new Object[0]);
        return this.metadataMap.containsKey(keyClass);
    }

    public void setFutureInstance(CachingCallable<DRONE> futureInstance) {
        if (this.hasFutureInstance()) {
            LOGGER.log(Level.FINE, "Future instance was previously set for drone point {0}, replacing.", this.dronePoint);
        }
        this.futureInstance = futureInstance;
    }

    public <CONF extends DroneConfiguration<CONF>> void setConfiguration(CONF configuration) {
        if (this.hasConfiguration()) {
            LOGGER.log(Level.FINE, "Configuration was previously set for drone point {0}, replacing.");
        }
        this.configuration = configuration;
    }

    public <KEY extends DronePointContext.MetadataKey<VALUE>, VALUE> void setMetadata(Class<KEY> keyClass, VALUE metadata) {
        Validate.notNull(keyClass, "Given key class cannot be null!", new Object[0]);
        this.metadataMap.put(keyClass, metadata);
    }

    public void removeFutureInstance() {
        if (!this.hasFutureInstance()) {
            LOGGER.log(Level.WARNING, "Could not remove future instance, because it was not set! Drone point: {0}.", this.dronePoint);
        }
        this.futureInstance = null;
    }

    public void removeConfiguration() {
        if (!this.hasConfiguration()) {
            LOGGER.log(Level.WARNING, "Could not remove configuration, because it was not set! Drone point: {0}.", this.dronePoint);
        }
        this.configuration = null;
    }

    public <KEY extends DronePointContext.MetadataKey<VALUE>, VALUE> void removeMetadata(Class<KEY> keyClass) {
        Validate.notNull(keyClass, "Given key class canoot be null!", new Object[0]);
        this.metadataMap.remove(keyClass);
    }

    private <T> T instantiateDrone(CachingCallable<T> droneCallable) {
        int timeout = ((DroneLifecycleManager.GlobalDroneConfiguration)((DroneContext)this.droneContext.get()).getGlobalDroneConfiguration(DroneLifecycleManager.GlobalDroneConfiguration.class)).getInstantiationTimeoutInSeconds();
        try {
            Future futureDrone = ((ExecutorService)this.executorService.get()).submit(droneCallable);
            Object drone = timeout > 0 ? futureDrone.get(timeout, TimeUnit.SECONDS) : futureDrone.get();
            return (T)drone;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to retrieve Drone Instance, thread interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (DroneTimeoutException.isCausedByTimeoutException(cause)) {
                throw new DroneTimeoutException(timeout, cause);
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause.getMessage(), cause);
        }
        catch (TimeoutException e) {
            throw new DroneTimeoutException(timeout, (Throwable)e);
        }
    }
}

