/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Qualifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static Constructor<?> getConstructor(final Class<?> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return clazz.getConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static <T> T newInstance(String className, Class<?>[] argumentTypes, Object[] arguments, Class<T> expectedType) {
        Object obj;
        if (className == null) {
            throw new IllegalArgumentException("ClassName must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            ClassLoader tccl = SecurityActions.getThreadContextClassLoader();
            Class<?> implClass = Class.forName(className, false, tccl);
            Constructor<?> constructor = SecurityActions.getConstructor(implClass, argumentTypes);
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + className + ", missing package from classpath?", e);
        }
        try {
            return expectedType.cast(obj);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Incorrect expected type, " + expectedType.getName() + ", defined for " + obj.getClass().getName());
        }
    }

    static boolean isClassPresent(String name) {
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static Map<Integer, Annotation[]> getParametersWithAnnotation(final Method method, final Class<? extends Annotation> annotationClass) {
        Map<Integer, Annotation[]> declaredParameters = AccessController.doPrivileged(new PrivilegedAction<Map<Integer, Annotation[]>>(){

            @Override
            public Map<Integer, Annotation[]> run() {
                LinkedHashMap<Integer, Annotation[]> foundParameters = new LinkedHashMap<Integer, Annotation[]>();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], annotationClass)) continue;
                    foundParameters.put(i, parameterAnnotations[i]);
                }
                return foundParameters;
            }
        });
        return declaredParameters;
    }

    static List<Field> getFieldsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Field field : nextSource.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(annotationClass)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                    }
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> needle) {
        for (Annotation a : annotations) {
            if (a.annotationType() != needle) continue;
            return true;
        }
        return false;
    }

    static Class<? extends Annotation> getQualifier(final Field field) {
        Annotation[] annotations = AccessController.doPrivileged(new PrivilegedAction<Annotation[]>(){

            @Override
            public Annotation[] run() {
                return field.getAnnotations();
            }
        });
        return SecurityActions.getQualifier(annotations);
    }

    static Object getFieldValue(final Object instance, final Field field) {
        try {
            Object value = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalArgumentException, IllegalAccessException {
                    return field.get(instance);
                }
            });
            return value;
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw new IllegalStateException("Unable to get field value of " + field.getName() + " due to: " + t.getMessage(), t.getCause());
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static void setFieldValue(final Object instance, final Field field, final Object value) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IllegalArgumentException, IllegalAccessException {
                    field.set(instance, value);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            if (t instanceof IllegalAccessException) {
                throw new IllegalStateException("Unable to set field value of " + field.getName() + " due to: " + t.getMessage(), t.getCause());
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    static Class<? extends Annotation> getQualifier(Annotation[] annotations) {
        ArrayList<Class<? extends Annotation>> candidates = new ArrayList<Class<? extends Annotation>>();
        for (Annotation a : annotations) {
            if (!a.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            candidates.add(a.annotationType());
        }
        if (candidates.isEmpty()) {
            return Default.class;
        }
        if (candidates.size() == 1) {
            return (Class)candidates.get(0);
        }
        throw new IllegalStateException("Unable to determine Qualifier, multiple (" + candidates.size() + ") Qualifier annotations were present");
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

