/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.domain;

import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.test.impl.MapObject;
import org.jboss.arquillian.container.test.spi.client.protocol.Protocol;
import org.jboss.arquillian.container.test.spi.client.protocol.ProtocolConfiguration;
import org.jboss.arquillian.core.spi.Validate;

public class ProtocolDefinition {
    private Protocol<?> protocol;
    private Map<String, String> protocolConfiguration;
    private boolean defaultProtocol = false;

    public ProtocolDefinition(Protocol<?> protocol) {
        this(protocol, new HashMap<String, String>(), false);
    }

    public ProtocolDefinition(Protocol<?> protocol, Map<String, String> protocolConfiguration) {
        this(protocol, protocolConfiguration, false);
    }

    public ProtocolDefinition(Protocol<?> protocol, Map<String, String> protocolConfiguration, boolean defaultProtocol) {
        Validate.notNull(protocol, (String)"Protocol must be specified");
        Validate.notNull(protocolConfiguration, (String)"ProtocolConfiguration must be specified");
        Validate.notNull((Object)defaultProtocol, (String)"DefaultProtocol must be specified");
        this.protocol = protocol;
        this.protocolConfiguration = protocolConfiguration;
        this.defaultProtocol = defaultProtocol;
    }

    public ProtocolDescription getProtocolDescription() {
        return this.protocol.getDescription();
    }

    public boolean isDefaultProtocol() {
        return this.defaultProtocol;
    }

    public Protocol<?> getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.protocol.getDescription().getName();
    }

    public Map<String, String> getProtocolConfiguration() {
        return this.protocolConfiguration;
    }

    public ProtocolConfiguration createProtocolConfiguration() throws Exception {
        return this.createProtocolConfiguration(this.protocolConfiguration);
    }

    public ProtocolConfiguration createProtocolConfiguration(Map<String, String> configuration) throws Exception {
        Validate.notNull(configuration, (String)"ProtocolConfiguration must be specified");
        ProtocolConfiguration config = (ProtocolConfiguration)this.protocol.getProtocolConfigurationClass().newInstance();
        MapObject.populate(config, configuration);
        return config;
    }
}

