/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi.jmx;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.Manifest;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.osgi.CommonDeployableContainer;
import org.jboss.arquillian.container.osgi.jmx.JMXContainerConfiguration;
import org.jboss.arquillian.container.osgi.jmx.http.SimpleHTTPServer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.osgi.framework.BundleException;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.ServiceStateMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXDeployableContainer<T extends JMXContainerConfiguration>
extends CommonDeployableContainer<T> {
    static final Logger logger = LoggerFactory.getLogger((String)JMXDeployableContainer.class.getPackage().getName());
    protected final Map<String, BundleHandle> deployedBundles = new HashMap<String, BundleHandle>();
    private JMXContainerConfiguration config;
    @Inject
    @ContainerScoped
    protected InstanceProducer<MBeanServerConnection> mbeanServerInstance;
    protected FrameworkMBean frameworkMBean;
    protected BundleStateMBean bundleStateMBean;
    protected ServiceStateMBean serviceStateMBean;

    protected JMXContainerConfiguration getContainerConfiguration() {
        return this.config;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-osgi");
    }

    @Override
    public void setup(T configuration) {
        super.setup(configuration);
        this.config = configuration;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            Manifest manifest = new Manifest(archive.get("/META-INF/MANIFEST.MF").getAsset().openStream());
            OSGiMetaData metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
            BundleHandle handle = this.installBundle(archive);
            this.deployedBundles.put(metadata.getBundleSymbolicName(), handle);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new DeploymentException("Cannot deploy: " + archive.getName(), (Throwable)ex);
        }
        MBeanServerConnection mbeanServer = (MBeanServerConnection)this.mbeanServerInstance.get();
        return new ProtocolMetaData().addContext((Object)new JMXContext(mbeanServer));
    }

    public void deploy(Descriptor desc) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            Manifest manifest = new Manifest(archive.get("/META-INF/MANIFEST.MF").getAsset().openStream());
            OSGiMetaData metadata = OSGiMetaDataBuilder.load((Manifest)manifest);
            this.undeploy(metadata.getBundleSymbolicName());
        }
        catch (IOException e) {
            throw new DeploymentException("Cannot undeploy: " + archive.getName(), (Throwable)e);
        }
    }

    private void undeploy(String symbolicName) throws DeploymentException {
        BundleHandle handle = this.deployedBundles.remove(symbolicName);
        if (handle != null) {
            long bundleId;
            String bundleState = null;
            try {
                bundleId = handle.getBundleId();
                CompositeData bundleType = this.bundleStateMBean.getBundle(bundleId);
                if (bundleType != null) {
                    bundleState = (String)bundleType.get("State");
                }
            }
            catch (IOException e) {
                return;
            }
            if (bundleState != null && !bundleState.equals("UNINSTALLED")) {
                try {
                    bundleId = handle.getBundleId();
                    this.frameworkMBean.uninstallBundle(bundleId);
                }
                catch (IOException ex) {
                    logger.error("Cannot undeploy: " + symbolicName, (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void refresh() throws Exception {
    }

    public void undeploy(Descriptor desc) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void uninstallBundle(long bundleId) throws Exception {
        try {
            this.frameworkMBean.uninstallBundle(bundleId);
            logger.info("Bundle '" + bundleId + " was uninstalled");
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot uninstall " + bundleId, (Throwable)ex);
        }
    }

    public void stop() throws LifecycleException {
    }

    @Override
    public long installBundle(Archive<?> archive, boolean start) throws Exception {
        BundleHandle bundleHandle = this.installBundle(archive);
        if (start) {
            this.startBundle(bundleHandle.getBundleId());
            this.awaitBundleActive(bundleHandle.getBundleId(), 30L, TimeUnit.SECONDS);
        }
        return bundleHandle.getBundleId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleHandle installBundle(Archive<?> archive) throws BundleException, IOException {
        VirtualFile virtualFile = this.toVirtualFile(archive);
        try {
            BundleHandle bundleHandle = this.installBundle(archive.getName(), virtualFile);
            return bundleHandle;
        }
        finally {
            VFSUtils.safeClose((Closeable)virtualFile);
        }
    }

    private BundleHandle installBundle(String location, VirtualFile virtualFile) throws BundleException, IOException {
        BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)virtualFile);
        URL streamURL = info.getRoot().getStreamURL();
        return this.installBundle(location, streamURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleHandle installBundle(String location, URL streamURL) throws BundleException, IOException {
        URL serverUrl = streamURL;
        SimpleHTTPServer server = null;
        if (!JMXDeployableContainer.isLocalHost(this.config)) {
            server = new SimpleHTTPServer();
            serverUrl = server.serve(streamURL);
            server.start();
        }
        try {
            long bundleId = this.frameworkMBean.installBundleFromURL(location, serverUrl.toExternalForm());
            String symbolicName = this.bundleStateMBean.getSymbolicName(bundleId);
            String version = this.bundleStateMBean.getVersion(bundleId);
            BundleHandle bundleHandle = new BundleHandle(bundleId, symbolicName, version);
            return bundleHandle;
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
    }

    private static boolean isLocalHost(JMXContainerConfiguration config) {
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(config.getJmxServiceURL());
            InetAddress addr = InetAddress.getByName(serviceURL.getHost());
            if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
                return true;
            }
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private VirtualFile toVirtualFile(Archive<?> archive) throws IOException {
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        return AbstractVFS.toVirtualFile((String)archive.getName(), (InputStream)exporter.exportAsInputStream());
    }

    protected void awaitBeginningStartLevel(Integer beginningStartLevel, long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        int startLevel = 0;
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            startLevel = this.frameworkMBean.getFrameworkStartLevel();
            if (startLevel >= beginningStartLevel) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Beginning start level [" + beginningStartLevel + "] not reached: " + startLevel);
    }

    @Override
    protected void awaitBootstrapCompleteService(String service) {
        try {
            this.awaitBootstrapCompleteService(service, 30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain bootsrap complete service: " + service, e);
        }
    }

    protected void awaitBootstrapCompleteService(String serviceName, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, IOException {
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            TabularData list = this.serviceStateMBean.listServices(serviceName, null);
            if (list.size() > 0) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Timeout while waiting for service: " + serviceName);
    }

    protected void awaitBundleActive(long bundleId, long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        String bundleState = null;
        while (System.currentTimeMillis() < timeoutMillis) {
            bundleState = this.bundleStateMBean.getState(bundleId);
            if ("ACTIVE".equals(bundleState)) {
                return;
            }
            Thread.sleep(500L);
        }
        throw new TimeoutException("Arquillian bundle [" + bundleId + "] not started: " + bundleState);
    }

    protected MBeanServerConnection getMBeanServerConnection(final long timeout, final TimeUnit unit) throws TimeoutException {
        Callable<MBeanServerConnection> callable = new Callable<MBeanServerConnection>(){

            @Override
            public MBeanServerConnection call() throws Exception {
                Exception lastException = null;
                long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
                while (System.currentTimeMillis() < timeoutMillis) {
                    try {
                        return JMXDeployableContainer.this.getMBeanServerConnection();
                    }
                    catch (Exception ex) {
                        lastException = ex;
                        Thread.sleep(500L);
                    }
                }
                TimeoutException timeoutException = new TimeoutException();
                timeoutException.initCause(lastException);
                throw timeoutException;
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<MBeanServerConnection> future = executor.submit(callable);
        try {
            return future.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection() throws IOException {
        String[] credentials = new String[]{this.config.getJmxUsername(), this.config.getJmxPassword()};
        Map<String, String[]> env = Collections.singletonMap("jmx.remote.credentials", credentials);
        JMXServiceURL serviceURL = new JMXServiceURL(this.config.getJmxServiceURL());
        JMXConnector connector = JMXConnectorFactory.connect(serviceURL, env);
        return connector.getMBeanServerConnection();
    }

    protected <U> U getMBeanProxy(final MBeanServerConnection mbeanServer, final ObjectName oname, final Class<U> type, final long timeout, final TimeUnit unit) throws TimeoutException {
        Callable callable = new Callable<U>(){

            @Override
            public U call() throws Exception {
                Throwable lastException = null;
                long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
                while (System.currentTimeMillis() < timeoutMillis) {
                    Set<ObjectName> names = mbeanServer.queryNames(oname, null);
                    if (names.size() == 1) {
                        ObjectName instanceName = names.iterator().next();
                        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, instanceName, type, false);
                    }
                    Thread.sleep(500L);
                }
                logger.warn("Cannot get MBean proxy for type: " + oname, lastException);
                throw new TimeoutException();
            }
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future future = executor.submit(callable);
        try {
            return (U)future.get(timeout, unit);
        }
        catch (TimeoutException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void startBundle(String symbolicName, String version) throws Exception {
        BundleHandle bHandle = this.deployedBundles.get(symbolicName);
        if (!(bHandle != null && bHandle.getSymbolicName().equals(symbolicName) && bHandle.getVersion().equals(version) || (bHandle = this.getBundle(symbolicName, version)) != null)) {
            throw new IllegalStateException("Bundle '" + symbolicName + ":" + version + "' was not found");
        }
        this.startBundle(bHandle.getBundleId());
    }

    public void startBundle(long bundleId) throws Exception {
        this.frameworkMBean.startBundle(bundleId);
    }

    protected BundleHandle getBundle(String symbolicName, String version) throws Exception {
        TabularData listBundles = this.bundleStateMBean.listBundles();
        for (CompositeData bundleType : listBundles.values()) {
            Long bundleId = (Long)bundleType.get("Identifier");
            String auxName = (String)bundleType.get("SymbolicName");
            String auxVersion = (String)bundleType.get("Version");
            if (!symbolicName.equals(auxName) || !version.equals(auxVersion)) continue;
            return new BundleHandle(bundleId, symbolicName, auxVersion);
        }
        return null;
    }

    static class BundleHandle {
        private long bundleId;
        private String symbolicName;
        private String version;

        BundleHandle(long bundleId, String symbolicName, String version) {
            this.bundleId = bundleId;
            this.symbolicName = symbolicName;
            this.version = version;
        }

        long getBundleId() {
            return this.bundleId;
        }

        String getSymbolicName() {
            return this.symbolicName;
        }

        String getVersion() {
            return this.version;
        }

        public String toString() {
            return "[" + this.bundleId + "]" + this.symbolicName + ":" + this.version;
        }
    }
}

