/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.util.List;
import org.jboss.arquillian.container.osgi.CommonContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.osgi.bundle.ArquillianBundleGenerator;
import org.jboss.shrinkwrap.api.Archive;

public abstract class CommonDeployableContainer<T extends CommonContainerConfiguration>
implements DeployableContainer<T> {
    private CommonContainerConfiguration config;
    private Long arquillianBundleId;
    @Inject
    private Instance<ServiceLoader> _serviceLoaderInstance;

    public boolean isAutostartBundle() {
        return this.config.isAutostartBundle();
    }

    public abstract long installBundle(Archive<?> var1, boolean var2) throws Exception;

    public abstract void refresh() throws Exception;

    public abstract void startBundle(String var1, String var2) throws Exception;

    public abstract void uninstallBundle(long var1) throws Exception;

    public void awaitBootstrapCompleteServices() {
        List<String> services = this.config.getBootstrapCompleteServices();
        if (services != null) {
            for (String service : services) {
                this.awaitBootstrapCompleteService(service);
            }
        }
    }

    protected abstract void awaitBootstrapCompleteService(String var1);

    protected long installArquillianBundle() throws Exception {
        ServiceLoader serviceLoader = (ServiceLoader)this._serviceLoaderInstance.get();
        ArquillianBundleGenerator arquillianBundleGenerator = (ArquillianBundleGenerator)serviceLoader.onlyOne(ArquillianBundleGenerator.class);
        Archive arquillianBundle = arquillianBundleGenerator.createArquillianBundle();
        this.arquillianBundleId = this.installBundle(arquillianBundle, true);
        return this.arquillianBundleId;
    }

    protected void uninstallArquillianBundle() throws Exception {
        if (this.arquillianBundleId == null) {
            throw new IllegalStateException("Arquillian bundle is not installed");
        }
        this.uninstallBundle(this.arquillianBundleId);
    }

    public void setup(T configuration) {
        this.config = configuration;
    }
}

