/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.osgi;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ClassContainer;

public abstract class AbstractOSGiApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    public void process(Archive<?> appArchive, TestClass testClass) {
        Manifest manifest = this.getBundleManifest(appArchive);
        if (manifest == null) {
            manifest = this.createBundleManifest(appArchive.getName());
        }
        if (manifest != null) {
            this.enhanceApplicationArchive(appArchive, testClass, manifest);
            this.assertValidBundleArchive(appArchive);
        }
    }

    protected abstract Manifest createBundleManifest(String var1);

    private void enhanceApplicationArchive(Archive<?> appArchive, TestClass testClass, Manifest manifest) {
        if (!ClassContainer.class.isAssignableFrom(appArchive.getClass())) {
            throw new IllegalArgumentException("ClassContainer expected: " + appArchive);
        }
        Class javaClass = testClass.getJavaClass();
        HashSet classes = new HashSet();
        classes.add(javaClass);
        for (Class superclass = javaClass.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        if (!appArchive.getName().endsWith(".war")) {
            for (Class clazz : classes) {
                boolean testClassFound = false;
                String path = clazz.getName().replace('.', '/') + ".class";
                for (ArchivePath auxpath : appArchive.getContent().keySet()) {
                    if (!auxpath.toString().endsWith(path)) continue;
                    testClassFound = true;
                    break;
                }
                if (testClassFound) continue;
                ((ClassContainer)appArchive).addClass(clazz);
            }
        }
        final OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
        Attributes attributes = manifest.getMainAttributes();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String key = entry.getKey().toString();
            String value = (String)entry.getValue();
            if (key.equals("Manifest-Version")) continue;
            if (key.equals("Import-Package")) {
                String[] imports = AbstractOSGiApplicationArchiveProcessor.splitWithComma(value);
                builder.addImportPackages(imports);
                continue;
            }
            if (key.equals("Export-Package")) {
                String[] exports = AbstractOSGiApplicationArchiveProcessor.splitWithComma(value);
                builder.addExportPackages(exports);
                continue;
            }
            builder.addManifestHeader(key, value);
        }
        builder.addExportPackages(new Class[]{javaClass});
        builder.addImportPackages(new String[]{"org.jboss.arquillian.container.test.api", "org.jboss.arquillian.junit", "org.jboss.arquillian.osgi", "org.jboss.arquillian.test.api"});
        builder.addImportPackages(new String[]{"org.jboss.shrinkwrap.api", "org.jboss.shrinkwrap.api.asset", "org.jboss.shrinkwrap.api.spec"});
        builder.addImportPackages(new String[]{"org.junit", "org.junit.runner", "org.osgi.framework"});
        appArchive.delete(ArchivePaths.create((String)"META-INF/MANIFEST.MF"));
        appArchive.add(new Asset(){

            public InputStream openStream() {
                return builder.openStream();
            }
        }, "META-INF/MANIFEST.MF");
    }

    private void assertValidBundleArchive(Archive<?> archive) {
        try {
            Manifest manifest = this.getBundleManifest(archive);
            OSGiManifestBuilder.validateBundleManifest((Manifest)manifest);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Not a valid OSGi bundle: " + archive, ex);
        }
    }

    private Manifest getBundleManifest(Archive<?> archive) {
        try {
            Node node = archive.get("META-INF/MANIFEST.MF");
            if (node == null) {
                return null;
            }
            Manifest manifest = new Manifest(node.getAsset().openStream());
            return manifest;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static String[] splitWithComma(String value) {
        return value.split("(?x)       ,          (?=          (?:          [^\"]*     \"         [^\"]*     \"       )*         [^\"]*     $        )          ");
    }
}

