/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.otp.api;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.aerogear.security.otp.api.Hash;

public class Hmac {
    public static final String ALGORITHM = "RAW";
    private final Hash hash;
    private final byte[] secret;
    private final long currentInterval;

    public Hmac(Hash hash, byte[] secret, long currentInterval) {
        this.hash = hash;
        this.secret = secret;
        this.currentInterval = currentInterval;
    }

    public byte[] digest() throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] challenge = ByteBuffer.allocate(8).putLong(this.currentInterval).array();
        Mac mac = Mac.getInstance(this.hash.toString());
        SecretKeySpec macKey = new SecretKeySpec(this.secret, ALGORITHM);
        mac.init(macKey);
        return mac.doFinal(challenge);
    }
}

