/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.testapps.common;

import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;

public abstract class IntegerArrayReaderWriterBase {
    @Inject
    protected StepContext stepContext;
    @Inject
    @BatchProperty(name="data.count")
    protected Integer dataCount;
    @Inject
    @BatchProperty(name="partition.start")
    protected int partitionStart;
    @Inject
    @BatchProperty(name="partition.end")
    protected Integer partitionEnd;
    @Inject
    @BatchProperty(name="reader.fail.at")
    protected Integer readerFailAt;
    @Inject
    @BatchProperty(name="writer.fail.at")
    protected Integer writerFailAt;
    @Inject
    @BatchProperty(name="writer.sleep.time")
    protected long writerSleepTime;
    protected Integer[] data;
    protected int cursor;

    protected IntegerArrayReaderWriterBase() {
        System.out.printf("Instantiating %s%n", this);
    }

    protected void initData() {
        if (this.dataCount == null) {
            throw new IllegalStateException("data.count property is not injected.");
        }
        this.data = new Integer[this.dataCount.intValue()];
        if (this.readerFailAt == null) {
            this.readerFailAt = -1;
        }
        if (this.writerFailAt == null) {
            this.writerFailAt = -1;
        }
        if (this.partitionEnd == null) {
            this.partitionEnd = this.dataCount - 1;
        }
    }

    public void open(Serializable checkpoint) throws Exception {
        if (this.data == null) {
            this.initData();
        }
        this.cursor = checkpoint == null ? this.partitionStart : (Integer)checkpoint;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.cursor);
    }

    public void close() throws Exception {
    }
}

