/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.schedule;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.BatchRuntime;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jberet.schedule.ExecutorSchedulerImpl;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule._private.ScheduleExecutorLogger;
import org.jberet.schedule._private.ScheduleExecutorMessages;

public abstract class JobScheduler {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String PERSISTENT = "persistent";
    public static final String CALENDAR = "calendar";
    protected static final TimeUnit timeUnit = TimeUnit.MINUTES;
    protected static final String TIMER_SCHEDULER_LOOKUP = "java:module/TimerSchedulerBean";
    protected static final String MANAGED_EXECUTOR_SERVICE_LOOKUP = "java:comp/DefaultManagedScheduledExecutorService";
    private static volatile JobScheduler jobScheduler;

    protected JobScheduler() {
    }

    public static JobScheduler getJobScheduler() {
        return JobScheduler.getJobScheduler(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobScheduler getJobScheduler(Class<? extends JobScheduler> schedulerType, ConcurrentMap<String, JobSchedule> schedules, String managedScheduledExecutorServiceLookup) {
        JobScheduler result = jobScheduler;
        if (result != null) return result;
        Class<JobScheduler> clazz = JobScheduler.class;
        synchronized (JobScheduler.class) {
            block23: {
                result = jobScheduler;
                if (result != null) return result;
                if (schedulerType != null) {
                    try {
                        jobScheduler = result = schedulerType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        ScheduleExecutorLogger.LOGGER.createdJobScheduler(result, null);
                    }
                    catch (Throwable e) {
                        throw ScheduleExecutorMessages.MESSAGES.failToCreateJobScheduler(e, schedulerType);
                    }
                }
                InitialContext ic = null;
                try {
                    ic = new InitialContext();
                    try {
                        jobScheduler = result = (JobScheduler)ic.lookup(TIMER_SCHEDULER_LOOKUP);
                        ScheduleExecutorLogger.LOGGER.createdJobScheduler(result, TIMER_SCHEDULER_LOOKUP);
                    }
                    catch (NamingException e) {
                        if (managedScheduledExecutorServiceLookup != null) {
                            try {
                                ScheduledExecutorService mexe = (ScheduledExecutorService)ic.lookup(managedScheduledExecutorServiceLookup);
                                jobScheduler = result = new ExecutorSchedulerImpl(schedules, mexe);
                                ScheduleExecutorLogger.LOGGER.createdJobScheduler(result, managedScheduledExecutorServiceLookup);
                            }
                            catch (NamingException e2) {
                                ScheduleExecutorLogger.LOGGER.failToLookupManagedScheduledExecutorService(managedScheduledExecutorServiceLookup);
                                ScheduledExecutorService mexe = (ScheduledExecutorService)ic.lookup(MANAGED_EXECUTOR_SERVICE_LOOKUP);
                                jobScheduler = result = new ExecutorSchedulerImpl(schedules, mexe);
                                ScheduleExecutorLogger.LOGGER.createdJobScheduler(result, MANAGED_EXECUTOR_SERVICE_LOOKUP);
                            }
                            break block23;
                        }
                        ScheduledExecutorService mexe = (ScheduledExecutorService)ic.lookup(MANAGED_EXECUTOR_SERVICE_LOOKUP);
                        jobScheduler = result = new ExecutorSchedulerImpl(schedules, mexe);
                        ScheduleExecutorLogger.LOGGER.createdJobScheduler(result, MANAGED_EXECUTOR_SERVICE_LOOKUP);
                    }
                }
                catch (NamingException e) {
                    jobScheduler = result = new ExecutorSchedulerImpl(schedules);
                    ScheduleExecutorLogger.LOGGER.createdJobScheduler(result, null);
                }
                finally {
                    if (ic != null) {
                        try {
                            ic.close();
                        }
                        catch (NamingException namingException) {}
                    }
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return result;
        }
    }

    public static JobOperator getJobOperator() {
        return Holder.jobOperator;
    }

    public String[] getFeatures() {
        return EMPTY_STRING_ARRAY;
    }

    public void delete(String scheduleId) {
        this.cancel(scheduleId);
    }

    public abstract JobSchedule schedule(JobScheduleConfig var1);

    public abstract List<JobSchedule> getJobSchedules();

    public abstract boolean cancel(String var1);

    public abstract JobSchedule getJobSchedule(String var1);

    private static class Holder {
        private static final JobOperator jobOperator = BatchRuntime.getJobOperator();

        private Holder() {
        }
    }
}

