/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.job.model;

import java.util.List;
import javax.batch.operations.JobStartException;
import org.jberet.creation.ArchiveXmlLoader;
import org.jberet.job.model.AbstractMerger;
import org.jberet.job.model.Flow;
import org.jberet.job.model.FlowMerger;
import org.jberet.job.model.InheritableJobElement;
import org.jberet.job.model.Job;
import org.jberet.job.model.PropertiesHolder;
import org.jberet.job.model.Step;
import org.jberet.job.model.StepMerger;
import org.jberet.spi.JobXmlResolver;

public final class JobMerger
extends AbstractMerger<Job> {
    private JobMerger(Job child, ClassLoader classLoader, List<Job> loadedJobs, JobXmlResolver jobXmlResolver) throws JobStartException {
        super(child, classLoader, loadedJobs, jobXmlResolver);
        String parentName = child.getParent();
        if (parentName != null) {
            this.parent = ArchiveXmlLoader.loadJobXml(parentName, classLoader, loadedJobs, jobXmlResolver);
        }
        this.child = child;
    }

    public static void resolveInheritance(Job job, ClassLoader classLoader, List<Job> loadedJobs, JobXmlResolver jobXmlResolver) throws JobStartException {
        for (InheritableJobElement e : job.inheritingJobElements) {
            if (e instanceof Step) {
                if (e.getParent() == null) continue;
                StepMerger stepMerger = new StepMerger(job, (Step)e, classLoader, loadedJobs, jobXmlResolver);
                stepMerger.merge();
                continue;
            }
            if (e instanceof Job) {
                if (e.getParent() == null) continue;
                JobMerger jobMerger = new JobMerger((Job)e, classLoader, loadedJobs, jobXmlResolver);
                jobMerger.merge();
                continue;
            }
            if (e instanceof Flow) {
                if (e.getParent() == null) continue;
                FlowMerger flowMerger = new FlowMerger(job, (Flow)e, classLoader, loadedJobs, jobXmlResolver);
                flowMerger.merge();
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public void merge() throws JobStartException {
        this.checkInheritingElements(this.parent, ((Job)this.parent).getId());
        if (((Job)this.parent).getParent() != null) {
            JobMerger merger2 = new JobMerger((Job)this.parent, this.classLoader, this.loadedJobs, this.jobXmlResolver);
            this.recordInheritingElements(merger2);
            merger2.merge();
        }
        if (((Job)this.child).getRestartable() == null) {
            ((Job)this.child).setRestartable(((Job)this.parent).getRestartable());
        }
        JobMerger.mergeProperties((PropertiesHolder)((Object)this.parent), (PropertiesHolder)((Object)this.child));
        JobMerger.mergeListeners((InheritableJobElement)this.parent, (InheritableJobElement)this.child);
        ((Job)this.child).setParentAndJslName(null, null);
    }
}

