/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.model.Story;
import org.jbehave.web.selenium.RemoteWebDriverProvider;
import org.jbehave.web.selenium.SauceWebDriverProvider;
import org.jbehave.web.selenium.SeleniumContext;
import org.jbehave.web.selenium.SeleniumContextStoryReporter;
import org.jbehave.web.selenium.WebDriverProvider;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SauceContextStoryReporter
extends SeleniumContextStoryReporter {
    private final WebDriverProvider webDriverProvider;
    private ThreadLocal<String> storyName = new ThreadLocal();
    private ThreadLocal<SessionId> sessionIds = new ThreadLocal();
    private ThreadLocal<Boolean> passed = new ThreadLocal();
    private Map<String, String> storyToJobIds = new HashMap<String, String>();
    private static final Pattern SAUCE_LABS_VIDEO_URL_PATTERN = Pattern.compile("http.*\\.flv");

    public SauceContextStoryReporter(WebDriverProvider webDriverProvider, SeleniumContext seleniumContext, Map<String, String> storyToSauceUrlMap) {
        super(seleniumContext);
        this.webDriverProvider = webDriverProvider;
        this.storyToJobIds = storyToSauceUrlMap;
    }

    public void beforeStory(Story story, boolean givenStory) {
        this.storyName.set(story.getPath());
        this.passed.set(true);
    }

    @Override
    public void beforeScenario(String title) {
        block2: {
            try {
                super.beforeScenario(title);
                ((JavascriptExecutor)this.webDriverProvider.get()).executeScript("sauce:context=Scenario: " + title, new Object[0]);
                this.sessionIds.set(((RemoteWebDriver)this.webDriverProvider.get()).getSessionId());
                String payload = "{\"tags\":[" + this.getJobTags() + "], " + this.getBuildId() + "\"name\":\" " + this.getJobName() + "\"}";
                this.postJobUpdate(this.storyName.get(), this.sessionIds.get(), payload);
            }
            catch (WebDriverException e) {
                if (e.getMessage().startsWith("Error communicating with the remote browser. It may have died.")) break block2;
                throw e;
            }
        }
    }

    public void failed(String step, Throwable cause) {
        try {
            this.passed.set(false);
            ((JavascriptExecutor)this.webDriverProvider.get()).executeScript("sauce:context=(Scenario failed)", new Object[0]);
        }
        catch (RemoteWebDriverProvider.SauceLabsJobHasEnded sauceLabsJobHasEnded) {
            // empty catch block
        }
    }

    public void pending(String step) {
        block2: {
            try {
                ((JavascriptExecutor)this.webDriverProvider.get()).executeScript("sauce:context=(Pending Steps Encountered: '" + step + "', " + "No More Steps Processed)", new Object[0]);
            }
            catch (WebDriverException e) {
                if (e.getMessage().startsWith("Error communicating with the remote browser. It may have died.")) break block2;
                throw e;
            }
        }
    }

    public void afterScenario() {
        String as = "(After Scenario Steps, if any...)";
        try {
            ((JavascriptExecutor)this.webDriverProvider.get()).executeScript("sauce:context=" + as, new Object[0]);
        }
        catch (RemoteWebDriverProvider.SauceLabsJobHasEnded e) {
            System.err.println("Couldn't set context as Sauce Labs job has ended");
        }
        catch (WebDriverException e) {
            System.err.println("Unexpected WebDriver error while trying to set context '" + as + "' : " + e.getMessage());
        }
    }

    public void afterStory(boolean givenStory) {
        String storyName = this.storyName.get();
        if (storyName.equals("BeforeStories") || storyName.equals("AfterStories") || storyName.equals("BeforeStory") || storyName.equals("AfterStory") || storyName.equals("BeforeScenario") || storyName.equals("AfterScenario")) {
            return;
        }
        SessionId sessionId = this.sessionIds.get();
        if (sessionId == null) {
            return;
        }
        boolean pass = this.passed.get().equals(true);
        String payload = "{ \"passed\":" + pass + "}";
        this.postJobUpdate(storyName, sessionId, payload);
        System.out.println("Saucelabs Job URL for " + (this.passed.get() != false ? "passing" : "failing") + " '" + storyName + "' : " + this.storyToJobIds.get(storyName));
    }

    private void postJobUpdate(String storyName, SessionId sessionId, String payload) {
        try {
            URL url = new URL("http://saucelabs.com/rest/v1/" + SauceWebDriverProvider.getSauceUser() + "/jobs/" + sessionId.toString());
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SauceWebDriverProvider.getSauceUser(), SauceWebDriverProvider.getSauceAccessKey().toCharArray());
                }
            });
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(payload);
            writer.close();
            int rc = connection.getResponseCode();
            String jobUrl = null;
            if (rc == 200) {
                jobUrl = this.readResponseLinesFromSauceLabToGetJobUrl(new BufferedReader(new InputStreamReader(connection.getInputStream())));
                this.storyToJobIds.put(storyName, jobUrl);
            }
        }
        catch (IOException e) {
            System.err.println("SauceContextStoryReporter: Error updating Saucelabs job info: " + e.getMessage());
        }
    }

    protected String readResponseLinesFromSauceLabToGetJobUrl(BufferedReader reader) throws IOException {
        String responseLineFromSauceLabs;
        String jobUrl = "";
        while ((responseLineFromSauceLabs = reader.readLine()) != null) {
            jobUrl = jobUrl + this.processSauceLabsResponseLine(responseLineFromSauceLabs);
        }
        return jobUrl;
    }

    protected String processSauceLabsResponseLine(String responseLineFromSauceLabs) {
        String jobUrl = "";
        Matcher matcher = SAUCE_LABS_VIDEO_URL_PATTERN.matcher(responseLineFromSauceLabs);
        while (matcher.find()) {
            jobUrl = matcher.group().replace("/video.flv", "");
        }
        return jobUrl;
    }

    protected String getBuildId() {
        String buildId = System.getProperty("BUILD-ID");
        if (buildId != null) {
            return " \"build\":\"" + buildId + "\",";
        }
        return "";
    }

    protected String getJobName() {
        return this.storyName.get();
    }

    protected String getJobTags() {
        return "";
    }
}

