/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.net.MalformedURLException;
import java.util.Locale;
import org.jbehave.web.selenium.DelegatingWebDriverProvider;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

public class PropertyWebDriverProvider
extends DelegatingWebDriverProvider {
    public void initialize() {
        Browser browser = Browser.valueOf(Browser.class, System.getProperty("browser", "firefox").toUpperCase(this.usingLocale()));
        this.delegate.set(this.createDriver(browser));
    }

    private WebDriver createDriver(Browser browser) {
        switch (browser) {
            case ANDROID: {
                return this.createAndroidDriver();
            }
            case CHROME: {
                return this.createChromeDriver();
            }
            case FIREFOX: {
                return this.createFirefoxDriver();
            }
            default: {
                return this.createHtmlUnitDriver();
            }
            case IE: 
        }
        return this.createInternetExplorerDriver();
    }

    protected WebDriver createAndroidDriver() {
        try {
            String url = System.getProperty("webdriver.android.url", "http://localhost:8080/hub");
            ScreenOrientation screenOrientation = ScreenOrientation.valueOf((String)System.getProperty("webdriver.android.screenOrientation", "portrait").toUpperCase(this.usingLocale()));
            AndroidDriver driver = new AndroidDriver(url);
            driver.rotate(screenOrientation);
            return driver;
        }
        catch (MalformedURLException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    protected ChromeDriver createChromeDriver() {
        return new ChromeDriver();
    }

    protected FirefoxDriver createFirefoxDriver() {
        return new FirefoxDriver();
    }

    protected WebDriver createHtmlUnitDriver() {
        HtmlUnitDriver driver = new HtmlUnitDriver();
        boolean javascriptEnabled = Boolean.parseBoolean(System.getProperty("webdriver.htmlunit.javascriptEnabled", "true"));
        driver.setJavascriptEnabled(javascriptEnabled);
        return driver;
    }

    protected InternetExplorerDriver createInternetExplorerDriver() {
        return new InternetExplorerDriver();
    }

    protected Locale usingLocale() {
        return Locale.getDefault();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Browser {
        ANDROID,
        CHROME,
        FIREFOX,
        HTMLUNIT,
        IE;

    }
}

